/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ListContainerDatabasePatchesRequest
extends BmcRequest<Void> {
    private String autonomousContainerDatabaseId;
    private String compartmentId;
    private Integer limit;
    private String page;

    @ConstructorProperties(value={"autonomousContainerDatabaseId", "compartmentId", "limit", "page"})
    ListContainerDatabasePatchesRequest(String autonomousContainerDatabaseId, String compartmentId, Integer limit, String page) {
        this.autonomousContainerDatabaseId = autonomousContainerDatabaseId;
        this.compartmentId = compartmentId;
        this.limit = limit;
        this.page = page;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().autonomousContainerDatabaseId(this.autonomousContainerDatabaseId).compartmentId(this.compartmentId).limit(this.limit).page(this.page);
    }

    public String toString() {
        return "ListContainerDatabasePatchesRequest(super=" + super.toString() + ", autonomousContainerDatabaseId=" + this.getAutonomousContainerDatabaseId() + ", compartmentId=" + this.getCompartmentId() + ", limit=" + this.getLimit() + ", page=" + this.getPage() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListContainerDatabasePatchesRequest)) {
            return false;
        }
        ListContainerDatabasePatchesRequest other = (ListContainerDatabasePatchesRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        String this$autonomousContainerDatabaseId = this.getAutonomousContainerDatabaseId();
        String other$autonomousContainerDatabaseId = other.getAutonomousContainerDatabaseId();
        if (this$autonomousContainerDatabaseId == null ? other$autonomousContainerDatabaseId != null : !this$autonomousContainerDatabaseId.equals(other$autonomousContainerDatabaseId)) {
            return false;
        }
        String this$compartmentId = this.getCompartmentId();
        String other$compartmentId = other.getCompartmentId();
        if (this$compartmentId == null ? other$compartmentId != null : !this$compartmentId.equals(other$compartmentId)) {
            return false;
        }
        String this$page = this.getPage();
        String other$page = other.getPage();
        return !(this$page == null ? other$page != null : !this$page.equals(other$page));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ListContainerDatabasePatchesRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        String $autonomousContainerDatabaseId = this.getAutonomousContainerDatabaseId();
        result = result * 59 + ($autonomousContainerDatabaseId == null ? 43 : $autonomousContainerDatabaseId.hashCode());
        String $compartmentId = this.getCompartmentId();
        result = result * 59 + ($compartmentId == null ? 43 : $compartmentId.hashCode());
        String $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : $page.hashCode());
        return result;
    }

    public String getAutonomousContainerDatabaseId() {
        return this.autonomousContainerDatabaseId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public static class Builder
    implements BmcRequest.Builder<ListContainerDatabasePatchesRequest, Void> {
        private String autonomousContainerDatabaseId;
        private String compartmentId;
        private Integer limit;
        private String page;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListContainerDatabasePatchesRequest o) {
            this.autonomousContainerDatabaseId(o.getAutonomousContainerDatabaseId());
            this.compartmentId(o.getCompartmentId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListContainerDatabasePatchesRequest build() {
            ListContainerDatabasePatchesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder autonomousContainerDatabaseId(String autonomousContainerDatabaseId) {
            this.autonomousContainerDatabaseId = autonomousContainerDatabaseId;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public ListContainerDatabasePatchesRequest buildWithoutInvocationCallback() {
            return new ListContainerDatabasePatchesRequest(this.autonomousContainerDatabaseId, this.compartmentId, this.limit, this.page);
        }

        public String toString() {
            return "ListContainerDatabasePatchesRequest.Builder(autonomousContainerDatabaseId=" + this.autonomousContainerDatabaseId + ", compartmentId=" + this.compartmentId + ", limit=" + this.limit + ", page=" + this.page + ")";
        }
    }
}

