/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.php.api.PhpVersion;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.Block;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ConstantDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.EmptyStatement;
import org.netbeans.modules.php.editor.parser.astnodes.FieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.IfStatement;
import org.netbeans.modules.php.editor.parser.astnodes.InterfaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.SingleFieldDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Statement;
import org.netbeans.modules.php.editor.parser.astnodes.TraitDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.TypeDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.UseStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.HintRule;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.openide.filesystems.FileObject;

public abstract class PSR1Hint
extends HintRule {
    @Override
    public void invoke(PHPRuleContext context, List<Hint> result) {
        FileObject fileObject;
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() != null && (fileObject = phpParseResult.getSnapshot().getSource().getFileObject()) != null) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            CheckVisitor checkVisitor = this.createVisitor(fileObject, context.doc);
            phpParseResult.getProgram().accept(checkVisitor);
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            result.addAll(checkVisitor.getHints());
        }
    }

    abstract CheckVisitor createVisitor(FileObject var1, BaseDocument var2);

    @Override
    public boolean getDefaultEnabled() {
        return false;
    }

    private static abstract class CheckVisitor
    extends DefaultVisitor {
        private final PSR1Hint psr1hint;
        private final FileObject fileObject;
        private final BaseDocument baseDocument;
        private final List<Hint> hints;

        public CheckVisitor(PSR1Hint psr1hint, FileObject fileObject, BaseDocument baseDocument) {
            this.psr1hint = psr1hint;
            this.fileObject = fileObject;
            this.baseDocument = baseDocument;
            this.hints = new ArrayList<Hint>();
        }

        public List<Hint> getHints() {
            return this.hints;
        }

        protected void createHint(ASTNode node, String message) {
            OffsetRange offsetRange = new OffsetRange(node.getStartOffset(), node.getEndOffset());
            if (this.psr1hint.showHint(offsetRange, this.baseDocument)) {
                this.hints.add(new Hint((Rule)this.psr1hint, Bundle.PSR1ViolationHintText(message), this.fileObject, offsetRange, null, 500));
            }
        }
    }

    public static final class SideEffectHint
    extends PSR1Hint {
        private static final String HINT_ID = "PSR1.Hint.Side.Effect";

        @Override
        CheckVisitor createVisitor(FileObject fileObject, BaseDocument baseDocument) {
            return new SideEffectVisitor(this, fileObject, baseDocument);
        }

        public String getId() {
            return HINT_ID;
        }

        public String getDescription() {
            return Bundle.PSR1SideEffectHintDesc();
        }

        public String getDisplayName() {
            return Bundle.PSR1SideEffectHintDisp();
        }

        private static final class SideEffectVisitor
        extends CheckVisitor {
            private boolean containsDeclaration = false;
            private ASTNode firstSideEffectNode;

            public SideEffectVisitor(PSR1Hint psr1hint, FileObject fileObject, BaseDocument baseDocument) {
                super(psr1hint, fileObject, baseDocument);
            }

            @Override
            public void visit(Program node) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                this.checkStatements(node.getStatements());
                this.checkSideEffects();
            }

            private void checkStatements(List<Statement> statements) {
                for (Statement statement : statements) {
                    this.checkStatement(statement);
                }
            }

            private void checkStatement(ASTNode node) {
                if (SideEffectVisitor.isNamespaceDeclaration(node)) {
                    NamespaceDeclaration namespaceDeclaration = (NamespaceDeclaration)node;
                    this.checkStatements(namespaceDeclaration.getBody().getStatements());
                } else if (SideEffectVisitor.isDeclaration(node)) {
                    this.containsDeclaration = true;
                } else if (SideEffectVisitor.isCondition(node)) {
                    IfStatement ifStatement = (IfStatement)node;
                    this.checkCondition(ifStatement.getTrueStatement());
                    this.checkCondition(ifStatement.getFalseStatement());
                } else if (!SideEffectVisitor.isAllowedEverywhere(node)) {
                    this.initSideEffect(node);
                }
            }

            private void checkCondition(Statement node) {
                if (node instanceof Block) {
                    Block body = (Block)node;
                    this.checkStatements(body.getStatements());
                } else {
                    this.checkStatement(node);
                }
            }

            private void initSideEffect(ASTNode node) {
                if (this.firstSideEffectNode == null) {
                    this.firstSideEffectNode = node;
                }
            }

            private void checkSideEffects() {
                if (this.isSideEffect()) {
                    this.createHint(this.firstSideEffectNode, Bundle.PSR1SideEffectHintText());
                }
            }

            private boolean isSideEffect() {
                return this.firstSideEffectNode != null && this.containsDeclaration;
            }

            private static boolean isNamespaceDeclaration(ASTNode node) {
                return node instanceof NamespaceDeclaration;
            }

            private static boolean isCondition(ASTNode node) {
                return node instanceof IfStatement;
            }

            private static boolean isDeclaration(ASTNode node) {
                return node instanceof TypeDeclaration || node instanceof FunctionDeclaration || node instanceof ConstantDeclaration;
            }

            private static boolean isAllowedEverywhere(ASTNode node) {
                return node instanceof UseStatement || node instanceof NamespaceDeclaration || node instanceof EmptyStatement;
            }
        }
    }

    public static final class PropertyNameHint
    extends PSR1Hint {
        private static final String HINT_ID = "PSR1.Hint.Property";

        @Override
        CheckVisitor createVisitor(FileObject fileObject, BaseDocument baseDocument) {
            return new PropertyNameVisitor(this, fileObject, baseDocument);
        }

        public String getId() {
            return HINT_ID;
        }

        public String getDescription() {
            return Bundle.PSR1PropertyNameHintDesc();
        }

        public String getDisplayName() {
            return Bundle.PSR1PropertyNameHintDisp();
        }

        private static final class PropertyNameVisitor
        extends CheckVisitor {
            private static final Pattern STUDLY_CAPS_PATTERN = Pattern.compile("[A-Z][a-zA-Z0-9]*");
            private static final Pattern CAMEL_CASE_PATTERN = Pattern.compile("[a-z]+([A-Z][a-z0-9]*)*");
            private static final Pattern UNDER_SCORE_PATTERN = Pattern.compile("[a-z]+(_[a-z0-9]*)*");
            private final List<Pattern> possiblePatterns = new ArrayList<Pattern>();

            public PropertyNameVisitor(PSR1Hint psr1hint, FileObject fileObject, BaseDocument baseDocument) {
                super(psr1hint, fileObject, baseDocument);
            }

            @Override
            public void visit(FieldAccess node) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                this.checkProperty(node.getField());
                super.visit(node);
            }

            @Override
            public void visit(SingleFieldDeclaration node) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                this.checkProperty(node.getName());
                super.visit(node);
            }

            private void checkProperty(Variable node) {
                String propertyName = CodeUtils.extractVariableName(node);
                if (propertyName != null) {
                    String normalizedPropertyName;
                    String string = normalizedPropertyName = propertyName.startsWith("$") ? propertyName.substring(1) : propertyName;
                    if (this.possiblePatterns.isEmpty()) {
                        this.fetchPossiblePatterns(normalizedPropertyName);
                    }
                    if (!this.isValidPropertyName(normalizedPropertyName)) {
                        this.createHint(node, Bundle.PSR1PropertyNameHintText());
                    }
                }
            }

            private boolean isValidPropertyName(String propertyName) {
                boolean result = true;
                if (this.possiblePatterns.isEmpty()) {
                    result = false;
                } else if (this.possiblePatterns.size() == 1) {
                    Pattern pattern = this.possiblePatterns.get(0);
                    Matcher matcher = pattern.matcher(propertyName);
                    if (!matcher.matches()) {
                        result = false;
                    }
                } else {
                    ArrayList<Pattern> matchingPatterns = new ArrayList<Pattern>();
                    for (Pattern pattern : this.possiblePatterns) {
                        Matcher matcher = pattern.matcher(propertyName);
                        if (!matcher.matches()) continue;
                        matchingPatterns.add(pattern);
                    }
                    if (matchingPatterns.isEmpty()) {
                        result = false;
                    } else {
                        this.possiblePatterns.clear();
                        this.possiblePatterns.addAll(matchingPatterns);
                    }
                }
                return result;
            }

            private void fetchPossiblePatterns(String propertyName) {
                assert (this.possiblePatterns.isEmpty());
                Matcher studlyCapsMatcher = STUDLY_CAPS_PATTERN.matcher(propertyName);
                if (studlyCapsMatcher.matches()) {
                    this.possiblePatterns.add(STUDLY_CAPS_PATTERN);
                } else {
                    Matcher underScoreMatcher;
                    Matcher camelCaseMatcher = CAMEL_CASE_PATTERN.matcher(propertyName);
                    if (camelCaseMatcher.matches()) {
                        this.possiblePatterns.add(CAMEL_CASE_PATTERN);
                    }
                    if ((underScoreMatcher = UNDER_SCORE_PATTERN.matcher(propertyName)).matches()) {
                        this.possiblePatterns.add(UNDER_SCORE_PATTERN);
                    }
                }
            }
        }
    }

    public static class TypeDeclarationHint
    extends PSR1Hint {
        private static final String HINT_ID = "PSR1.Hint.Type";
        private FileObject fileObject;

        @Override
        CheckVisitor createVisitor(FileObject fileObject, BaseDocument baseDocument) {
            assert (fileObject != null);
            this.fileObject = fileObject;
            return new TypeDeclarationVisitor(this, fileObject, baseDocument);
        }

        protected boolean isPhp52() {
            return CodeUtils.isPhpVersion(this.fileObject, PhpVersion.PHP_5);
        }

        public String getId() {
            return HINT_ID;
        }

        public String getDescription() {
            return Bundle.PSR1TypeDeclarationHintDesc();
        }

        public String getDisplayName() {
            return Bundle.PSR1TypeDeclarationHintDisp();
        }

        private static final class TypeDeclarationVisitor
        extends CheckVisitor {
            private static final Pattern PHP52_TYPE_NAME_PATTERN = Pattern.compile("([A-Z][a-zA-Z0-9]*_)+[A-Z][a-zA-Z0-9]+");
            private static final Pattern PHP53_TYPE_NAME_PATTERN = Pattern.compile("[A-Z][a-zA-Z0-9]+");
            private final boolean isPhp52;
            private boolean isInNamedNamespaceDeclaration = false;
            private boolean isDeclaredType = false;

            public TypeDeclarationVisitor(TypeDeclarationHint typeDeclarationHint, FileObject fileObject, BaseDocument baseDocument) {
                super(typeDeclarationHint, fileObject, baseDocument);
                this.isPhp52 = typeDeclarationHint.isPhp52();
            }

            @Override
            public void visit(NamespaceDeclaration node) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                this.isInNamedNamespaceDeclaration = node.getName() != null;
                super.visit(node);
            }

            @Override
            public void visit(ClassDeclaration node) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                this.processTypeDeclaration(node);
            }

            @Override
            public void visit(InterfaceDeclaration node) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                this.processTypeDeclaration(node);
            }

            @Override
            public void visit(TraitDeclaration node) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                this.processTypeDeclaration(node);
            }

            private void processTypeDeclaration(TypeDeclaration node) {
                Identifier typeNameNode = node.getName();
                if (this.isDeclaredType) {
                    this.createHint(typeNameNode, Bundle.PSR1TypeDeclarationMoreTypesHintText());
                } else {
                    this.isDeclaredType = true;
                    this.processFirstDeclaration(typeNameNode);
                }
            }

            private void processFirstDeclaration(Identifier typeNameNode) {
                if (this.isPhp52) {
                    this.checkPhp52Violations(typeNameNode);
                } else {
                    this.checkPhp53Violations(typeNameNode);
                }
            }

            private void checkPhp52Violations(Identifier typeNameNode) {
                String typeName = typeNameNode.getName();
                if (typeName != null && !PHP52_TYPE_NAME_PATTERN.matcher(typeName).matches()) {
                    this.createHint(typeNameNode, Bundle.PSR1TypeDeclaration52HintText());
                }
            }

            private void checkPhp53Violations(Identifier typeNameNode) {
                String typeName = typeNameNode.getName();
                if (!this.isInNamedNamespaceDeclaration) {
                    this.createHint(typeNameNode, Bundle.PSR1TypeDeclaration53NoNsHintText());
                } else if (typeName != null && !PHP53_TYPE_NAME_PATTERN.matcher(typeName).matches()) {
                    this.createHint(typeNameNode, Bundle.PSR1TypeDeclaration53HintText());
                }
            }
        }
    }

    public static class MethodDeclarationHint
    extends PSR1Hint {
        private static final String HINT_ID = "PSR1.Hint.Method";
        private static final String MAGIC_METHODS = "__(construct|destruct|call|callStatic|get|set|isset|unset|sleep|wakeup|toString|invoke|set_state|clone)";
        private static final Pattern METHOD_PATTERN = Pattern.compile("([a-z]|__(construct|destruct|call|callStatic|get|set|isset|unset|sleep|wakeup|toString|invoke|set_state|clone))[a-zA-Z0-9]*");

        @Override
        CheckVisitor createVisitor(FileObject fileObject, BaseDocument baseDocument) {
            return new MethodDeclarationVisitor(this, fileObject, baseDocument);
        }

        public String getId() {
            return HINT_ID;
        }

        public String getDescription() {
            return Bundle.PSR1MethodDeclarationHintDesc();
        }

        public String getDisplayName() {
            return Bundle.PSR1MethodDeclarationHintDisp();
        }

        private static final class MethodDeclarationVisitor
        extends CheckVisitor {
            public MethodDeclarationVisitor(PSR1Hint psr1hint, FileObject fileObject, BaseDocument baseDocument) {
                super(psr1hint, fileObject, baseDocument);
            }

            @Override
            public void visit(MethodDeclaration node) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                Identifier functionNameNode = node.getFunction().getFunctionName();
                String methodName = functionNameNode.getName();
                if (methodName != null && !METHOD_PATTERN.matcher(methodName).matches()) {
                    this.createHint(functionNameNode, Bundle.PSR1MethodDeclarationHintText());
                }
            }
        }
    }

    public static class ConstantDeclarationHint
    extends PSR1Hint {
        private static final String HINT_ID = "PSR1.Hint.Constant";
        private static final Pattern CONSTANT_PATTERN = Pattern.compile("[A-Z0-9]+[A-Z0-9_]*[A-Z0-9]+");

        @Override
        CheckVisitor createVisitor(FileObject fileObject, BaseDocument baseDocument) {
            return new ConstantsVisitor(this, fileObject, baseDocument);
        }

        public String getId() {
            return HINT_ID;
        }

        public String getDescription() {
            return Bundle.PSR1ConstantHintDesc();
        }

        public String getDisplayName() {
            return Bundle.PSR1ConstantHintDisp();
        }

        private static final class ConstantsVisitor
        extends CheckVisitor {
            public ConstantsVisitor(PSR1Hint psr1hint, FileObject fileObject, BaseDocument baseDocument) {
                super(psr1hint, fileObject, baseDocument);
            }

            @Override
            public void visit(ConstantDeclaration node) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                for (Identifier constantNameNode : node.getNames()) {
                    String constantName = constantNameNode.getName();
                    if (constantName == null || CONSTANT_PATTERN.matcher(constantName).matches()) continue;
                    this.createHint(constantNameNode, Bundle.PSR1ConstantDeclarationHintText());
                }
            }
        }
    }
}

