/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.palette;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.html.palette.HtmlPaletteActions;
import org.netbeans.spi.palette.DragAndDropHandler;
import org.netbeans.spi.palette.PaletteActions;
import org.netbeans.spi.palette.PaletteController;
import org.netbeans.spi.palette.PaletteFactory;
import org.openide.util.Lookup;
import org.openide.util.datatransfer.ExTransferable;

public final class HtmlPaletteFactory {
    private static Map<String, PaletteController> PALETTES = new HashMap<String, PaletteController>();

    public static PaletteController getHtmlPalette() throws IOException {
        return HtmlPaletteFactory.getOrCreatePalette("HTMLPalette");
    }

    public static PaletteController getXhtmlPalette() throws IOException {
        return HtmlPaletteFactory.getOrCreatePalette("XHTMLPalette");
    }

    public static PaletteController getPalette(String mimeType) throws IOException {
        if ("text/html".equals(mimeType)) {
            return HtmlPaletteFactory.getHtmlPalette();
        }
        if ("text/xhtml".equals(mimeType)) {
            return HtmlPaletteFactory.getXhtmlPalette();
        }
        return null;
    }

    private static PaletteController getOrCreatePalette(String paletteFolder) throws IOException {
        PaletteController palette = PALETTES.get(paletteFolder);
        if (palette == null) {
            palette = PaletteFactory.createPalette((String)paletteFolder, (PaletteActions)new HtmlPaletteActions(), null, (DragAndDropHandler)new HtmlDragAndDropHandler());
            PALETTES.put(paletteFolder, palette);
        }
        return palette;
    }

    private static class HtmlDragAndDropHandler
    extends DragAndDropHandler {
        public HtmlDragAndDropHandler() {
            super(true);
        }

        public void customize(ExTransferable t, Lookup item) {
        }
    }
}

