/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.selenium2.java.api;

import java.util.Collection;
import org.netbeans.api.java.queries.UnitTestForSourceQuery;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.java.testrunner.JavaUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class Utils {
    public static final String RUN_SELENIUM_TESTS_REGEXP = "**/*IT.java";

    public static boolean isSupportEnabled(Class lookupClass, FileObject[] activatedFOs) {
        if (activatedFOs.length == 0) {
            return false;
        }
        FileObject firstFile = activatedFOs[0];
        Project p = FileOwnerQuery.getOwner((FileObject)firstFile);
        if (p == null) {
            return false;
        }
        if (p.getLookup().lookup(lookupClass) == null) {
            return false;
        }
        if (firstFile == p.getProjectDirectory()) {
            return true;
        }
        SourceGroup sourceGroup = Utils.findSourceGroup(firstFile);
        if (sourceGroup == null) {
            return false;
        }
        FileObject rootFolder = sourceGroup.getRootFolder();
        if (UnitTestForSourceQuery.findUnitTests((FileObject)rootFolder).length == 0 && UnitTestForSourceQuery.findSources((FileObject)rootFolder).length == 0) {
            return false;
        }
        if (activatedFOs.length == 1) {
            return true;
        }
        for (int i = 1; i < activatedFOs.length; ++i) {
            FileObject fileObj = activatedFOs[i];
            if (FileUtil.isParentOf((FileObject)rootFolder, (FileObject)fileObj) && sourceGroup.contains(fileObj)) continue;
            return false;
        }
        return true;
    }

    private static SourceGroup findSourceGroup(FileObject file) {
        SourceGroup[] srcGrps;
        Project project = FileOwnerQuery.getOwner((FileObject)file);
        if (project == null) {
            return null;
        }
        Sources src = ProjectUtils.getSources((Project)project);
        for (SourceGroup srcGrp : srcGrps = src.getSourceGroups("java")) {
            FileObject rootFolder = srcGrp.getRootFolder();
            if (file != rootFolder && !FileUtil.isParentOf((FileObject)rootFolder, (FileObject)file) || !srcGrp.contains(file)) continue;
            return srcGrp;
        }
        return null;
    }

    public static String[] getSourceAndTestClassNames(FileObject fileObj, boolean isTestNG, boolean isSelenium) {
        return JavaUtils.getSourceAndTestClassNames((FileObject)fileObj, (boolean)isTestNG, (boolean)isSelenium);
    }

    public static Object[] getTestSourceRoots(Collection<SourceGroup> createdSourceRoots, FileObject refFileObject) {
        return JavaUtils.getTestSourceRoots(createdSourceRoots, (FileObject)refFileObject);
    }
}

