/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.signing;

import com.google.common.collect.ImmutableMap;
import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.signing.internal.Constants;
import java.beans.ConstructorProperties;
import java.util.List;

@InternalSdk
public enum SigningStrategy {
    STANDARD(Constants.REQUIRED_SIGNING_HEADERS, Constants.OPTIONAL_SIGNING_HEADERS, false),
    OBJECT_STORAGE(Constants.REQUIRED_OBJECTSTORAGE_SIGNING_HEADERS, Constants.OPTIONAL_SIGNING_HEADERS, true),
    EXCLUDE_BODY(Constants.REQUIRED_EXCLUDE_BODY_SIGNING_HEADERS, Constants.OPTIONAL_SIGNING_HEADERS, true);

    private final ImmutableMap<String, List<String>> headersToSign;
    private final ImmutableMap<String, List<String>> optionalHeadersToSign;
    private final boolean skipContentHeadersForStreamingPutRequests;

    @ConstructorProperties(value={"headersToSign", "optionalHeadersToSign", "skipContentHeadersForStreamingPutRequests"})
    private SigningStrategy(ImmutableMap<String, List<String>> headersToSign, ImmutableMap<String, List<String>> optionalHeadersToSign, boolean skipContentHeadersForStreamingPutRequests) {
        this.headersToSign = headersToSign;
        this.optionalHeadersToSign = optionalHeadersToSign;
        this.skipContentHeadersForStreamingPutRequests = skipContentHeadersForStreamingPutRequests;
    }

    public ImmutableMap<String, List<String>> getHeadersToSign() {
        return this.headersToSign;
    }

    public ImmutableMap<String, List<String>> getOptionalHeadersToSign() {
        return this.optionalHeadersToSign;
    }

    public boolean isSkipContentHeadersForStreamingPutRequests() {
        return this.skipContentHeadersForStreamingPutRequests;
    }
}

