/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.internal;

import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorConsumer<REQUEST>
implements Consumer<Throwable> {
    private static final Logger LOG = LoggerFactory.getLogger(ErrorConsumer.class);
    private final AsyncHandler<REQUEST, ?> handler;
    private final REQUEST request;

    @Override
    public void accept(Throwable t) {
        if (this.handler != null) {
            this.handler.onError(this.request, t);
        } else {
            LOG.debug("Request failed, but no handler configured");
        }
    }

    @ConstructorProperties(value={"handler", "request"})
    public ErrorConsumer(AsyncHandler<REQUEST, ?> handler, REQUEST request) {
        this.handler = handler;
        this.request = request;
    }
}

