/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ObjectUtils;
import org.languagetool.Languages;
import org.languagetool.rules.Category;
import org.languagetool.rules.CategoryId;
import org.languagetool.rules.CorrectExample;
import org.languagetool.rules.ErrorTriggeringExample;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.IncorrectExample;
import org.languagetool.rules.patterns.AbstractPatternRule;
import org.languagetool.rules.patterns.Match;
import org.languagetool.rules.patterns.PatternRule;
import org.languagetool.rules.patterns.PatternToken;
import org.languagetool.rules.patterns.RegexPatternRule;
import org.languagetool.rules.patterns.XMLRuleHandler;
import org.languagetool.tagging.disambiguation.rules.DisambiguationPatternRule;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class PatternRuleHandler
extends XMLRuleHandler {
    public static final String TYPE = "type";
    static final String MARKER_TAG = "<marker>";
    static final String PLEASE_SPELL_ME = "<pleasespellme/>";
    private static final String EXTERNAL = "external";
    protected Category category;
    protected String categoryIssueType;
    protected String ruleGroupIssueType;
    protected String ruleIssueType;
    protected String name;
    protected String filterClassName;
    protected String filterArgs;
    private final List<DisambiguationPatternRule> rulegroupAntiPatterns = new ArrayList<DisambiguationPatternRule>();
    private final List<DisambiguationPatternRule> ruleAntiPatterns = new ArrayList<DisambiguationPatternRule>();
    private int subId;
    private boolean defaultOff;
    private boolean ruleGroupDefaultOff;
    private String ruleGroupDescription;
    private int startPos = -1;
    private int endPos = -1;
    private int tokenCountForMarker;
    private int antiPatternCounter;
    private boolean inRule;
    private boolean relaxedMode = false;
    private boolean inAntiPattern;
    private final String sourceFile;

    public PatternRuleHandler() {
        this.sourceFile = null;
    }

    public PatternRuleHandler(String sourceFile) {
        this.sourceFile = sourceFile;
    }

    void setRelaxedMode(boolean relaxedMode) {
        this.relaxedMode = relaxedMode;
    }

    @Override
    public void startElement(String namespaceURI, String lName, String qName, Attributes attrs) throws SAXException {
        switch (qName) {
            case "category": {
                String catName = attrs.getValue("name");
                String catId = attrs.getValue("id");
                Category.Location location = "yes".equals(attrs.getValue(EXTERNAL)) ? Category.Location.EXTERNAL : Category.Location.INTERNAL;
                boolean onByDefault = !"off".equals(attrs.getValue("default"));
                String tabName = attrs.getValue("tab");
                this.category = new Category(catId != null ? new CategoryId(catId) : null, catName, location, onByDefault, tabName);
                if (attrs.getValue(TYPE) == null) break;
                this.categoryIssueType = attrs.getValue(TYPE);
                break;
            }
            case "rules": {
                String languageStr = attrs.getValue("lang");
                this.language = Languages.getLanguageForShortCode(languageStr);
                break;
            }
            case "regexp": {
                this.inRegex = true;
                this.regexMode = "exact".equals(attrs.getValue(TYPE)) ? XMLRuleHandler.RegexpMode.EXACT : XMLRuleHandler.RegexpMode.SMART;
                this.regexCaseSensitive = attrs.getValue("case_sensitive") != null && "yes".equals(attrs.getValue("case_sensitive"));
                this.regexpMark = attrs.getValue("mark") != null ? Integer.parseInt(attrs.getValue("mark")) : 0;
                break;
            }
            case "rule": {
                this.regex = new StringBuilder();
                this.inRule = true;
                this.shortMessage = new StringBuilder();
                this.message = new StringBuilder();
                this.suggestionsOutMsg = new StringBuilder();
                this.url = new StringBuilder();
                this.id = attrs.getValue("id");
                this.name = attrs.getValue("name");
                if (this.inRuleGroup) {
                    ++this.subId;
                    if (this.id == null) {
                        this.id = this.ruleGroupId;
                    }
                    if (this.name == null) {
                        this.name = this.ruleGroupDescription;
                    }
                }
                if (this.inRuleGroup && this.ruleGroupDefaultOff && attrs.getValue("default") != null) {
                    throw new RuntimeException("Rule group " + this.ruleGroupId + " is off by default, thus rule " + this.id + " cannot specify 'default=...'");
                }
                this.defaultOff = this.inRuleGroup && this.ruleGroupDefaultOff ? true : "off".equals(attrs.getValue("default"));
                this.correctExamples = new ArrayList();
                this.incorrectExamples = new ArrayList();
                this.errorTriggeringExamples = new ArrayList();
                this.suggestionMatches.clear();
                this.suggestionMatchesOutMsg.clear();
                if (attrs.getValue(TYPE) == null) break;
                this.ruleIssueType = attrs.getValue(TYPE);
                break;
            }
            case "pattern": {
                this.startPattern(attrs);
                this.tokenCountForMarker = 0;
                break;
            }
            case "antipattern": {
                this.inAntiPattern = true;
                ++this.antiPatternCounter;
                this.caseSensitive = "yes".equals(attrs.getValue("case_sensitive"));
                this.tokenCounter = 0;
                this.tokenCountForMarker = 0;
                break;
            }
            case "and": {
                this.inAndGroup = true;
                ++this.tokenCountForMarker;
                break;
            }
            case "or": {
                this.inOrGroup = true;
                ++this.tokenCountForMarker;
                break;
            }
            case "unify": {
                this.inUnification = true;
                this.uniNegation = "yes".equals(attrs.getValue("negate"));
                break;
            }
            case "unify-ignore": {
                this.inUnificationNeutral = true;
                break;
            }
            case "feature": {
                this.uFeature = attrs.getValue("id");
                break;
            }
            case "type": {
                this.uType = attrs.getValue("id");
                this.uTypeList.add(this.uType);
                break;
            }
            case "token": {
                this.setToken(attrs);
                if (this.inAndGroup || this.inOrGroup) break;
                ++this.tokenCountForMarker;
                break;
            }
            case "exception": {
                this.setExceptions(attrs);
                break;
            }
            case "example": {
                String typeVal = attrs.getValue(TYPE);
                if ("incorrect".equals(typeVal) || attrs.getValue("correction") != null) {
                    this.inIncorrectExample = true;
                    this.incorrectExample = new StringBuilder();
                    this.exampleCorrection = new StringBuilder();
                    if (attrs.getValue("correction") == null) break;
                    this.exampleCorrection.append(attrs.getValue("correction"));
                    break;
                }
                if ("triggers_error".equals(typeVal)) {
                    this.inErrorTriggerExample = true;
                    this.errorTriggerExample = new StringBuilder();
                    break;
                }
                this.inCorrectExample = true;
                this.correctExample = new StringBuilder();
                break;
            }
            case "filter": {
                this.filterClassName = attrs.getValue("class");
                this.filterArgs = attrs.getValue("args");
                break;
            }
            case "message": {
                this.inMessage = true;
                this.inSuggestion = false;
                this.message = new StringBuilder();
                break;
            }
            case "suggestion": {
                if ("yes".equals(attrs.getValue("suppress_misspelled"))) {
                    this.message.append(PLEASE_SPELL_ME);
                }
                if (this.inMessage) {
                    this.message.append("<suggestion>");
                } else {
                    this.suggestionsOutMsg.append("<suggestion>");
                }
                this.inSuggestion = true;
                break;
            }
            case "short": {
                if (this.inRule) {
                    this.inShortMessage = true;
                    this.shortMessage = new StringBuilder();
                    break;
                }
                this.inShortMessageForRuleGroup = true;
                this.shortMessageForRuleGroup = new StringBuilder();
                break;
            }
            case "url": {
                if (this.inRule) {
                    this.inUrl = true;
                    this.url = new StringBuilder();
                    break;
                }
                this.inUrlForRuleGroup = true;
                this.urlForRuleGroup = new StringBuilder();
                break;
            }
            case "rulegroup": {
                this.ruleGroupId = attrs.getValue("id");
                this.ruleGroupDescription = attrs.getValue("name");
                this.ruleGroupDefaultOff = "off".equals(attrs.getValue("default"));
                this.urlForRuleGroup = new StringBuilder();
                this.shortMessageForRuleGroup = new StringBuilder();
                this.inRuleGroup = true;
                this.subId = 0;
                if (attrs.getValue(TYPE) == null) break;
                this.ruleGroupIssueType = attrs.getValue(TYPE);
                break;
            }
            case "match": {
                this.setMatchElement(attrs);
                break;
            }
            case "marker": {
                if (this.inIncorrectExample) {
                    this.incorrectExample.append(MARKER_TAG);
                    break;
                }
                if (this.inCorrectExample) {
                    this.correctExample.append(MARKER_TAG);
                    break;
                }
                if (this.inErrorTriggerExample) {
                    this.errorTriggerExample.append(MARKER_TAG);
                    break;
                }
                if (!this.inPattern && !this.inAntiPattern) break;
                this.startPos = this.tokenCounter;
                this.inMarker = true;
                break;
            }
            case "unification": {
                this.uFeature = attrs.getValue("feature");
                this.inUnificationDef = true;
                break;
            }
            case "equivalence": {
                this.uType = attrs.getValue(TYPE);
                break;
            }
            case "phrases": {
                this.inPhrases = true;
                break;
            }
            case "includephrases": {
                break;
            }
            case "phrase": {
                if (!this.inPhrases) break;
                this.phraseId = attrs.getValue("id");
                break;
            }
            case "phraseref": {
                if (attrs.getValue("idref") == null) break;
                this.preparePhrase(attrs);
                ++this.tokenCountForMarker;
            }
        }
    }

    @Override
    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        switch (qName) {
            case "category": {
                this.categoryIssueType = null;
                break;
            }
            case "regexp": {
                this.inRegex = false;
                break;
            }
            case "rule": {
                this.suggestionMatchesOutMsg = this.addLegacyMatches(this.suggestionMatchesOutMsg, this.suggestionsOutMsg.toString(), false);
                if (this.relaxedMode && this.id == null) {
                    this.id = "";
                }
                if (this.relaxedMode && this.name == null) {
                    this.name = "";
                }
                if (this.phrasePatternTokens.isEmpty()) {
                    ArrayList<PatternToken> tmpPatternTokens = new ArrayList<PatternToken>();
                    this.createRules(new ArrayList<PatternToken>(this.patternTokens), tmpPatternTokens, 0);
                } else {
                    if (!this.patternTokens.isEmpty()) {
                        for (List ph : this.phrasePatternTokens) {
                            ph.addAll(new ArrayList(this.patternTokens));
                        }
                    }
                    for (List phrasePatternToken : this.phrasePatternTokens) {
                        this.processElement(phrasePatternToken);
                        ArrayList<PatternToken> tmpPatternTokens = new ArrayList<PatternToken>();
                        this.createRules(phrasePatternToken, tmpPatternTokens, 0);
                    }
                }
                this.patternTokens.clear();
                if (this.phrasePatternTokens != null) {
                    this.phrasePatternTokens.clear();
                }
                this.ruleIssueType = null;
                this.inRule = false;
                this.filterClassName = null;
                this.filterArgs = null;
                break;
            }
            case "exception": {
                this.finalizeExceptions();
                break;
            }
            case "and": {
                this.inAndGroup = false;
                this.andGroupCounter = 0;
                ++this.tokenCounter;
                break;
            }
            case "or": {
                this.inOrGroup = false;
                this.orGroupCounter = 0;
                ++this.tokenCounter;
                break;
            }
            case "token": {
                this.finalizeTokens();
                break;
            }
            case "pattern": {
                this.inPattern = false;
                if (this.lastPhrase) {
                    this.patternTokens.clear();
                }
                this.tokenCounter = 0;
                break;
            }
            case "antipattern": {
                String antiId = this.id;
                if (this.inRuleGroup) {
                    antiId = this.subId > 0 ? this.ruleGroupId + "[" + this.subId + "]" : this.ruleGroupId;
                }
                DisambiguationPatternRule rule = new DisambiguationPatternRule(antiId + "_antipattern:" + this.antiPatternCounter, "antipattern", this.language, this.patternTokens, null, null, DisambiguationPatternRule.DisambiguatorAction.IMMUNIZE);
                if (this.startPos != -1 && this.endPos != -1) {
                    rule.setStartPositionCorrection(this.startPos);
                    rule.setEndPositionCorrection(this.endPos - this.tokenCountForMarker);
                } else {
                    for (PatternToken patternToken : this.patternTokens) {
                        patternToken.setInsideMarker(true);
                    }
                }
                this.patternTokens.clear();
                if (this.inRule) {
                    this.ruleAntiPatterns.add(rule);
                } else {
                    this.rulegroupAntiPatterns.add(rule);
                }
                this.tokenCounter = 0;
                this.inAntiPattern = false;
                break;
            }
            case "example": {
                if (this.inCorrectExample) {
                    this.correctExamples.add(new CorrectExample(this.correctExample.toString()));
                } else if (this.inIncorrectExample) {
                    IncorrectExample example;
                    ArrayList<String> corrections = new ArrayList<String>();
                    corrections.addAll(Arrays.asList(this.exampleCorrection.toString().split("\\|")));
                    if (corrections.size() > 0) {
                        if (this.exampleCorrection.toString().endsWith("|")) {
                            corrections.add("");
                        }
                        example = new IncorrectExample(this.incorrectExample.toString(), corrections);
                    } else {
                        example = new IncorrectExample(this.incorrectExample.toString());
                    }
                    this.incorrectExamples.add(example);
                } else if (this.inErrorTriggerExample) {
                    this.errorTriggeringExamples.add(new ErrorTriggeringExample(this.errorTriggerExample.toString()));
                }
                this.inCorrectExample = false;
                this.inIncorrectExample = false;
                this.inErrorTriggerExample = false;
                this.correctExample = new StringBuilder();
                this.incorrectExample = new StringBuilder();
                this.errorTriggerExample = new StringBuilder();
                this.exampleCorrection = new StringBuilder();
                break;
            }
            case "message": {
                this.suggestionMatches = this.addLegacyMatches(this.suggestionMatches, this.message.toString(), true);
                this.inMessage = false;
                break;
            }
            case "suggestion": {
                if (this.inMessage) {
                    this.message.append("</suggestion>");
                } else {
                    this.suggestionsOutMsg.append("</suggestion>");
                }
                this.inSuggestion = false;
                break;
            }
            case "short": {
                this.inShortMessage = false;
                this.inShortMessageForRuleGroup = false;
                break;
            }
            case "url": {
                this.inUrl = false;
                this.inUrlForRuleGroup = false;
                break;
            }
            case "match": {
                if (this.inMessage) {
                    ((Match)this.suggestionMatches.get(this.suggestionMatches.size() - 1)).setLemmaString(this.match.toString());
                } else if (this.inSuggestion) {
                    ((Match)this.suggestionMatchesOutMsg.get(this.suggestionMatchesOutMsg.size() - 1)).setLemmaString(this.match.toString());
                } else if (this.inToken) {
                    this.tokenReference.setLemmaString(this.match.toString());
                }
                this.inMatch = false;
                break;
            }
            case "rulegroup": {
                this.urlForRuleGroup = new StringBuilder();
                this.shortMessageForRuleGroup = new StringBuilder();
                this.inRuleGroup = false;
                this.ruleGroupIssueType = null;
                this.rulegroupAntiPatterns.clear();
                this.antiPatternCounter = 0;
                this.ruleGroupDefaultOff = false;
                this.defaultOff = false;
                break;
            }
            case "marker": {
                if (this.inCorrectExample) {
                    this.correctExample.append("</marker>");
                    break;
                }
                if (this.inIncorrectExample) {
                    this.incorrectExample.append("</marker>");
                    break;
                }
                if (this.inErrorTriggerExample) {
                    this.errorTriggerExample.append("</marker>");
                    break;
                }
                if (!this.inPattern && !this.inAntiPattern) break;
                this.endPos = this.tokenCountForMarker;
                this.inMarker = false;
                break;
            }
            case "phrase": {
                if (!this.inPhrases) break;
                this.finalizePhrase();
                break;
            }
            case "includephrases": {
                this.patternTokens.clear();
                break;
            }
            case "phrases": {
                if (!this.inPhrases) break;
                this.inPhrases = false;
                break;
            }
            case "unification": {
                this.inUnificationDef = false;
                break;
            }
            case "feature": {
                this.equivalenceFeatures.put(this.uFeature, this.uTypeList);
                this.uTypeList = new ArrayList();
                break;
            }
            case "unify": {
                this.inUnification = false;
                this.equivalenceFeatures = new HashMap();
                int lastElement = this.patternTokens.size() - 1;
                ((PatternToken)this.patternTokens.get(lastElement)).setLastInUnification();
                if (!this.uniNegation) break;
                ((PatternToken)this.patternTokens.get(lastElement)).setUniNegation();
                break;
            }
            case "unify-ignore": {
                this.inUnificationNeutral = false;
            }
        }
    }

    private void createRules(List<PatternToken> elemList, List<PatternToken> tmpPatternTokens, int numElement) {
        String shortMessage = "";
        if (this.shortMessage != null && this.shortMessage.length() > 0) {
            shortMessage = this.shortMessage.toString();
        } else if (this.shortMessageForRuleGroup != null && this.shortMessageForRuleGroup.length() > 0) {
            shortMessage = this.shortMessageForRuleGroup.toString();
        }
        if (numElement >= elemList.size()) {
            AbstractPatternRule rule;
            if (tmpPatternTokens.size() > 0) {
                rule = new PatternRule(this.id, this.language, tmpPatternTokens, this.name, this.message.toString(), shortMessage, this.suggestionsOutMsg.toString(), this.phrasePatternTokens.size() > 1);
                rule.setSourceFile(this.sourceFile);
            } else if (this.regex.length() > 0) {
                int flags = this.regexCaseSensitive ? 0 : 66;
                String regexStr = this.regex.toString();
                if (this.regexMode == XMLRuleHandler.RegexpMode.SMART) {
                    regexStr = this.replaceSpacesInRegex(regexStr);
                }
                if (this.ruleAntiPatterns.size() > 0 || this.rulegroupAntiPatterns.size() > 0) {
                    throw new RuntimeException("<regexp> rules currently cannot be used together with <antipattern>. Rule id: " + this.id + "[" + this.subId + "]");
                }
                rule = new RegexPatternRule(this.id, this.name, this.message.toString(), shortMessage, this.suggestionsOutMsg.toString(), this.language, Pattern.compile(regexStr, flags), this.regexpMark);
            } else {
                throw new IllegalStateException("Neither '<pattern>' tokens nor '<regex>' is set in rule '" + this.id + "'");
            }
            this.setRuleFilter(this.filterClassName, this.filterArgs, rule);
            this.prepareRule(rule);
            this.rules.add(rule);
        } else {
            PatternToken patternToken = elemList.get(numElement);
            if (patternToken.hasOrGroup()) {
                ArrayList suggestionMatchesBackup = new ArrayList(this.suggestionMatches);
                ArrayList suggestionMatchesOutMsgBackup = new ArrayList(this.suggestionMatchesOutMsg);
                int startPosBackup = this.startPos;
                int endPosBackup = this.endPos;
                ArrayList<DisambiguationPatternRule> ruleAntiPatternsBackup = new ArrayList<DisambiguationPatternRule>(this.ruleAntiPatterns);
                for (PatternToken patternTokenOfOrGroup : patternToken.getOrGroup()) {
                    ArrayList<PatternToken> tmpElements2 = new ArrayList<PatternToken>();
                    tmpElements2.addAll(tmpPatternTokens);
                    tmpElements2.add((PatternToken)ObjectUtils.clone((Object)patternTokenOfOrGroup));
                    this.createRules(elemList, tmpElements2, numElement + 1);
                    this.startPos = startPosBackup;
                    this.endPos = endPosBackup;
                    this.suggestionMatches = suggestionMatchesBackup;
                    this.suggestionMatchesOutMsg = suggestionMatchesOutMsgBackup;
                    this.ruleAntiPatterns.addAll(ruleAntiPatternsBackup);
                }
            }
            tmpPatternTokens.add((PatternToken)ObjectUtils.clone((Object)patternToken));
            this.createRules(elemList, tmpPatternTokens, numElement + 1);
        }
    }

    String replaceSpacesInRegex(String s) {
        StringBuilder sb = new StringBuilder();
        boolean inBracket = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '[') {
                inBracket = true;
            } else if (c == ']') {
                inBracket = false;
            }
            if (c == ' ' && !inBracket) {
                sb.append("(?:[\\s\u00a0\u202f]+)");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    protected void prepareRule(AbstractPatternRule rule) {
        if (this.startPos != -1 && this.endPos != -1) {
            rule.setStartPositionCorrection(this.startPos);
            rule.setEndPositionCorrection(this.endPos - this.tokenCountForMarker);
        }
        this.startPos = -1;
        this.endPos = -1;
        rule.setCorrectExamples(this.correctExamples);
        rule.setIncorrectExamples(this.incorrectExamples);
        rule.setErrorTriggeringExamples(this.errorTriggeringExamples);
        rule.setCategory(this.category);
        if (!this.rulegroupAntiPatterns.isEmpty()) {
            rule.setAntiPatterns(this.rulegroupAntiPatterns);
        }
        if (!this.ruleAntiPatterns.isEmpty()) {
            rule.setAntiPatterns(this.ruleAntiPatterns);
            this.ruleAntiPatterns.clear();
        }
        if (this.inRuleGroup) {
            rule.setSubId(Integer.toString(this.subId));
        } else {
            rule.setSubId("1");
        }
        this.caseSensitive = false;
        for (Match m : this.suggestionMatches) {
            rule.addSuggestionMatch(m);
        }
        if (this.phrasePatternTokens.size() <= 1) {
            this.suggestionMatches.clear();
        }
        for (Match m : this.suggestionMatchesOutMsg) {
            rule.addSuggestionMatchOutMsg(m);
        }
        this.suggestionMatchesOutMsg.clear();
        if (this.category == null) {
            throw new RuntimeException("Cannot activate rule '" + this.id + "', it is outside of a <category>...</category>");
        }
        if (this.defaultOff) {
            rule.setDefaultOff();
        }
        if (this.url != null && this.url.length() > 0) {
            try {
                rule.setUrl(new URL(this.url.toString()));
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Could not parse URL for rule: " + rule + ": '" + this.url + "'", e);
            }
        }
        if (this.urlForRuleGroup != null && this.urlForRuleGroup.length() > 0) {
            try {
                rule.setUrl(new URL(this.urlForRuleGroup.toString()));
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Could not parse URL for rule: " + rule + ": '" + this.urlForRuleGroup + "'", e);
            }
        }
        if (this.ruleIssueType != null) {
            rule.setLocQualityIssueType(ITSIssueType.getIssueType(this.ruleIssueType));
        } else if (this.ruleGroupIssueType != null) {
            rule.setLocQualityIssueType(ITSIssueType.getIssueType(this.ruleGroupIssueType));
        } else if (this.categoryIssueType != null) {
            rule.setLocQualityIssueType(ITSIssueType.getIssueType(this.categoryIssueType));
        }
    }

    @Override
    public void characters(char[] buf, int offset, int len) {
        String s = new String(buf, offset, len);
        if (this.inException) {
            this.exceptions.append(s);
        } else if (this.inToken) {
            this.elements.append(s);
        } else if (this.inCorrectExample) {
            this.correctExample.append(s);
        } else if (this.inIncorrectExample) {
            this.incorrectExample.append(s);
        } else if (this.inErrorTriggerExample) {
            this.errorTriggerExample.append(s);
        } else if (this.inMatch) {
            this.match.append(s);
        } else if (this.inMessage) {
            this.message.append(s);
        } else if (this.inSuggestion) {
            this.suggestionsOutMsg.append(s);
        } else if (this.inShortMessage) {
            this.shortMessage.append(s);
        } else if (this.inShortMessageForRuleGroup) {
            this.shortMessageForRuleGroup.append(s);
        } else if (this.inUrl) {
            this.url.append(s);
        } else if (this.inUrlForRuleGroup) {
            this.urlForRuleGroup.append(s);
        } else if (this.inRegex) {
            this.regex.append(s);
        }
    }
}

