/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

class RequestCounter {
    private final AtomicInteger reqCount = new AtomicInteger();
    private final AtomicInteger handleCount = new AtomicInteger();
    private final Map<Integer, String> handleIps = new ConcurrentHashMap<Integer, String>();

    RequestCounter() {
    }

    int getHandleCount() {
        return this.handleCount.get();
    }

    int getRequestCount() {
        return this.reqCount.get();
    }

    void incrementHandleCount(String ip, int uniqueId) {
        this.handleCount.incrementAndGet();
        this.handleIps.put(uniqueId, ip);
    }

    int incrementRequestCount() {
        return this.reqCount.incrementAndGet();
    }

    void decrementHandleCount(int uniqueId) {
        this.handleCount.decrementAndGet();
        this.handleIps.remove(uniqueId);
    }

    int getDistinctIps() {
        HashSet<String> ips = new HashSet<String>();
        for (Map.Entry<Integer, String> entry : this.handleIps.entrySet()) {
            ips.add(entry.getValue());
        }
        return ips.size();
    }
}

