/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.languagetool.AnalyzedSentence;
import org.languagetool.InputSentence;
import org.languagetool.SimpleInputSentence;
import org.languagetool.rules.RuleMatch;

public class ResultCache {
    private final Cache<InputSentence, List<RuleMatch>> matchesCache;
    private final Cache<SimpleInputSentence, AnalyzedSentence> sentenceCache;

    public ResultCache(long maxSize) {
        this(maxSize, 5, TimeUnit.MINUTES);
    }

    public ResultCache(long maxSize, int expireAfter, TimeUnit timeUnit) {
        if (maxSize < 0L) {
            throw new IllegalArgumentException("Result cache size must be >= 0: " + maxSize);
        }
        this.matchesCache = CacheBuilder.newBuilder().maximumSize(maxSize / 2L).recordStats().expireAfterAccess((long)expireAfter, timeUnit).build();
        this.sentenceCache = CacheBuilder.newBuilder().maximumSize(maxSize / 2L).recordStats().expireAfterAccess((long)expireAfter, timeUnit).build();
    }

    public double hitRate() {
        return (this.matchesCache.stats().hitRate() + this.sentenceCache.stats().hitRate()) / 2.0;
    }

    public double requestCount() {
        return this.matchesCache.stats().requestCount() + this.sentenceCache.stats().requestCount();
    }

    public long hitCount() {
        return this.matchesCache.stats().hitCount() + this.sentenceCache.stats().hitCount();
    }

    public List<RuleMatch> getIfPresent(InputSentence key) {
        return (List)this.matchesCache.getIfPresent((Object)key);
    }

    public AnalyzedSentence getIfPresent(SimpleInputSentence key) {
        return (AnalyzedSentence)this.sentenceCache.getIfPresent((Object)key);
    }

    public void put(InputSentence key, List<RuleMatch> sentenceMatches) {
        this.matchesCache.put((Object)key, sentenceMatches);
    }

    public void put(SimpleInputSentence key, AnalyzedSentence aSentence) {
        this.sentenceCache.put((Object)key, (Object)aSentence);
    }

    protected Cache<InputSentence, List<RuleMatch>> getMatchesCache() {
        return this.matchesCache;
    }

    protected Cache<SimpleInputSentence, AnalyzedSentence> getSentenceCache() {
        return this.sentenceCache;
    }
}

