/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.imagery;

import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import javax.swing.JLabel;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.gui.preferences.imagery.AddImageryPanel;
import org.openstreetmap.josm.gui.widgets.JosmTextArea;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class AddMVTLayerPanel
extends AddImageryPanel {
    private final JosmTextField mvtZoom = new JosmTextField();
    private final JosmTextArea mvtUrl = new JosmTextArea(3, 40).transferFocusOnTab();

    public AddMVTLayerPanel() {
        this.add((Component)new JLabel(I18n.tr("{0} Make sure OSM has the permission to use this service", "1.")), GBC.eol());
        this.add((Component)new JLabel(I18n.tr("{0} Enter URL (may be a style sheet url)", "2.")), GBC.eol());
        this.add((Component)new JLabel("<html>" + Utils.joinAsHtmlUnorderedList(Arrays.asList(I18n.tr("{0} is replaced by tile zoom level, also supported:<br>offsets to the zoom level: {1} or {2}<br>reversed zoom level: {3}", "{zoom}", "{zoom+1}", "{zoom-1}", "{19-zoom}"), I18n.tr("{0} is replaced by X-coordinate of the tile", "{x}"), I18n.tr("{0} is replaced by Y-coordinate of the tile", "{y}"), I18n.tr("{0} is replaced by a random selection from the given comma separated list, e.g. {1}", "{switch:...}", "{switch:a,b,c}"))) + "</html>"), GBC.eol().fill());
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                AddMVTLayerPanel.this.mvtUrl.setText(AddMVTLayerPanel.this.buildMvtUrl());
            }
        };
        this.add((Component)this.rawUrl, GBC.eop().fill());
        this.rawUrl.setLineWrap(true);
        this.rawUrl.addKeyListener(keyAdapter);
        this.add((Component)new JLabel(I18n.tr("{0} Enter maximum zoom (optional)", "3.")), GBC.eol());
        this.mvtZoom.addKeyListener(keyAdapter);
        this.add((Component)this.mvtZoom, GBC.eop().fill());
        this.add((Component)new JLabel(I18n.tr("{0} Edit generated {1} URL (optional)", "4.", "MVT")), GBC.eol());
        this.add((Component)this.mvtUrl, GBC.eop().fill());
        this.mvtUrl.setLineWrap(true);
        this.add((Component)new JLabel(I18n.tr("{0} Enter name for this layer", "5.")), GBC.eol());
        this.add((Component)this.name, GBC.eop().fill());
        this.registerValidableComponent(this.mvtUrl);
    }

    private String buildMvtUrl() {
        StringBuilder a = new StringBuilder("mvt");
        String z = AddMVTLayerPanel.sanitize(this.mvtZoom.getText());
        if (!z.isEmpty()) {
            a.append('[').append(z).append(']');
        }
        a.append(':').append(AddMVTLayerPanel.sanitize(this.getImageryRawUrl(), ImageryInfo.ImageryType.MVT));
        return a.toString();
    }

    @Override
    public ImageryInfo getImageryInfo() {
        ImageryInfo generated = new ImageryInfo(this.getImageryName(), this.getMvtUrl());
        generated.setImageryType(ImageryInfo.ImageryType.MVT);
        return generated;
    }

    protected final String getMvtUrl() {
        return AddMVTLayerPanel.sanitize(this.mvtUrl.getText());
    }

    @Override
    protected boolean isImageryValid() {
        return !this.getImageryName().isEmpty() && !this.getMvtUrl().isEmpty();
    }
}

