/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.pair;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.DefaultListSelectionModel;
import javax.swing.table.DefaultTableModel;
import org.openstreetmap.josm.command.conflict.ConflictResolveCommand;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.conflict.pair.ComparePairType;
import org.openstreetmap.josm.gui.conflict.pair.ListRole;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.util.ChangeNotifier;
import org.openstreetmap.josm.gui.util.TableHelper;
import org.openstreetmap.josm.gui.widgets.JosmComboBoxModel;
import org.openstreetmap.josm.gui.widgets.OsmPrimitivesTableModel;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public abstract class AbstractListMergeModel<T extends PrimitiveId, C extends ConflictResolveCommand>
extends ChangeNotifier {
    public static final String FROZEN_PROP = AbstractListMergeModel.class.getName() + ".frozen";
    private static final int MAX_DELETED_PRIMITIVE_IN_DIALOG = 5;
    protected Map<ListRole, ArrayList<T>> entries = new EnumMap<ListRole, ArrayList<T>>(ListRole.class);
    protected EntriesTableModel myEntriesTableModel;
    protected EntriesTableModel theirEntriesTableModel;
    protected EntriesTableModel mergedEntriesTableModel;
    protected EntriesSelectionModel myEntriesSelectionModel;
    protected EntriesSelectionModel theirEntriesSelectionModel;
    protected EntriesSelectionModel mergedEntriesSelectionModel;
    private final Set<PropertyChangeListener> listeners;
    private boolean isFrozen;
    private final ComparePairListModel comparePairListModel;
    private DataSet myDataset;
    private Map<PrimitiveId, PrimitiveId> mergedMap;

    protected abstract T cloneEntryForMergedList(T var1);

    public abstract boolean isEqualEntry(T var1, T var2);

    protected abstract void setValueAt(DefaultTableModel var1, Object var2, int var3, int var4);

    public OsmPrimitive getMyPrimitive(T entry) {
        return this.getMyPrimitiveById((PrimitiveId)entry);
    }

    public final OsmPrimitive getMyPrimitiveById(PrimitiveId entry) {
        OsmPrimitive result = this.myDataset.getPrimitiveById(entry);
        if (result == null && this.mergedMap != null) {
            PrimitiveId id = this.mergedMap.get(entry);
            if (id == null && entry instanceof OsmPrimitive) {
                id = this.mergedMap.get(((OsmPrimitive)entry).getPrimitiveId());
            }
            if (id != null) {
                result = this.myDataset.getPrimitiveById(id);
            }
        }
        return result;
    }

    protected void buildMyEntriesTableModel() {
        this.myEntriesTableModel = new EntriesTableModel(ListRole.MY_ENTRIES);
    }

    protected void buildTheirEntriesTableModel() {
        this.theirEntriesTableModel = new EntriesTableModel(ListRole.THEIR_ENTRIES);
    }

    protected void buildMergedEntriesTableModel() {
        this.mergedEntriesTableModel = new EntriesTableModel(ListRole.MERGED_ENTRIES);
    }

    protected List<T> getMergedEntries() {
        return this.entries.get((Object)ListRole.MERGED_ENTRIES);
    }

    protected List<T> getMyEntries() {
        return this.entries.get((Object)ListRole.MY_ENTRIES);
    }

    protected List<T> getTheirEntries() {
        return this.entries.get((Object)ListRole.THEIR_ENTRIES);
    }

    public int getMyEntriesSize() {
        return this.getMyEntries().size();
    }

    public int getMergedEntriesSize() {
        return this.getMergedEntries().size();
    }

    public int getTheirEntriesSize() {
        return this.getTheirEntries().size();
    }

    protected AbstractListMergeModel() {
        for (ListRole role : ListRole.values()) {
            this.entries.put(role, new ArrayList());
        }
        this.buildMyEntriesTableModel();
        this.buildTheirEntriesTableModel();
        this.buildMergedEntriesTableModel();
        this.myEntriesSelectionModel = new EntriesSelectionModel((List)this.entries.get((Object)ListRole.MY_ENTRIES));
        this.theirEntriesSelectionModel = new EntriesSelectionModel((List)this.entries.get((Object)ListRole.THEIR_ENTRIES));
        this.mergedEntriesSelectionModel = new EntriesSelectionModel((List)this.entries.get((Object)ListRole.MERGED_ENTRIES));
        this.listeners = new HashSet<PropertyChangeListener>();
        this.comparePairListModel = new ComparePairListModel();
        this.setFrozen(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        Set<PropertyChangeListener> set = this.listeners;
        synchronized (set) {
            if (listener != null) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        Set<PropertyChangeListener> set = this.listeners;
        synchronized (set) {
            if (listener != null) {
                this.listeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireFrozenChanged(boolean oldValue, boolean newValue) {
        Set<PropertyChangeListener> set = this.listeners;
        synchronized (set) {
            PropertyChangeEvent evt = new PropertyChangeEvent(this, FROZEN_PROP, oldValue, newValue);
            this.listeners.forEach(listener -> listener.propertyChange(evt));
        }
    }

    public final void setFrozen(boolean isFrozen) {
        boolean oldValue = this.isFrozen;
        this.isFrozen = isFrozen;
        this.fireFrozenChanged(oldValue, this.isFrozen);
    }

    public final boolean isFrozen() {
        return this.isFrozen;
    }

    public OsmPrimitivesTableModel getMyTableModel() {
        return this.myEntriesTableModel;
    }

    public OsmPrimitivesTableModel getTheirTableModel() {
        return this.theirEntriesTableModel;
    }

    public OsmPrimitivesTableModel getMergedTableModel() {
        return this.mergedEntriesTableModel;
    }

    public EntriesSelectionModel getMySelectionModel() {
        return this.myEntriesSelectionModel;
    }

    public EntriesSelectionModel getTheirSelectionModel() {
        return this.theirEntriesSelectionModel;
    }

    public EntriesSelectionModel getMergedSelectionModel() {
        return this.mergedEntriesSelectionModel;
    }

    protected void fireModelDataChanged() {
        this.myEntriesTableModel.fireTableDataChanged();
        this.theirEntriesTableModel.fireTableDataChanged();
        this.mergedEntriesTableModel.fireTableDataChanged();
        this.fireStateChanged();
    }

    protected void copyToTop(ListRole role, int ... rows) {
        this.copy(role, rows, 0);
        this.mergedEntriesSelectionModel.setSelectionInterval(0, rows.length - 1);
    }

    public void copyMyToTop(int ... rows) {
        this.copyToTop(ListRole.MY_ENTRIES, rows);
    }

    public void copyTheirToTop(int ... rows) {
        this.copyToTop(ListRole.THEIR_ENTRIES, rows);
    }

    public void copyToEnd(ListRole source, int ... rows) {
        this.copy(source, rows, this.getMergedEntriesSize());
        this.mergedEntriesSelectionModel.setSelectionInterval(this.getMergedEntriesSize() - rows.length, this.getMergedEntriesSize() - 1);
    }

    public void copyMyToEnd(int ... rows) {
        this.copyToEnd(ListRole.MY_ENTRIES, rows);
    }

    public void copyTheirToEnd(int ... rows) {
        this.copyToEnd(ListRole.THEIR_ENTRIES, rows);
    }

    public void clearMerged() {
        this.getMergedEntries().clear();
        this.fireModelDataChanged();
    }

    protected final void initPopulate(OsmPrimitive my, OsmPrimitive their, Map<PrimitiveId, PrimitiveId> mergedMap) {
        CheckParameterUtil.ensureParameterNotNull(my, "my");
        CheckParameterUtil.ensureParameterNotNull(their, "their");
        this.myDataset = my.getDataSet();
        this.mergedMap = mergedMap;
        this.getMergedEntries().clear();
        this.getMyEntries().clear();
        this.getTheirEntries().clear();
    }

    protected void alertCopyFailedForDeletedPrimitives(List<PrimitiveId> deletedIds) {
        List items = deletedIds.stream().limit(5L).map(Object::toString).collect(Collectors.toList());
        if (deletedIds.size() > 5) {
            items.add(I18n.tr("{0} more...", deletedIds.size() - 5));
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<html>").append(I18n.tr("The following objects could not be copied to the target object<br>because they are deleted in the target dataset:", new Object[0])).append(Utils.joinAsHtmlUnorderedList(items)).append("</html>");
        HelpAwareOptionPane.showOptionDialog(MainApplication.getMainFrame(), sb.toString(), I18n.tr("Merging deleted objects failed", new Object[0]), 2, HelpUtil.ht("/Dialog/Conflict#MergingDeletedPrimitivesFailed"));
    }

    private void copy(ListRole sourceRole, int[] rows, int position) {
        if (position < 0 || position > this.getMergedEntriesSize()) {
            throw new IllegalArgumentException("Position must be between 0 and " + this.getMergedEntriesSize() + " but is " + position);
        }
        ArrayList<PrimitiveId> newItems = new ArrayList<PrimitiveId>(rows.length);
        List source = this.entries.get((Object)sourceRole);
        ArrayList<PrimitiveId> deletedIds = new ArrayList<PrimitiveId>();
        for (int row : rows) {
            PrimitiveId entry = (PrimitiveId)source.get(row);
            OsmPrimitive primitive = this.getMyPrimitive(entry);
            if (primitive == null) continue;
            if (!primitive.isDeleted()) {
                PrimitiveId clone = this.cloneEntryForMergedList(entry);
                newItems.add(clone);
                continue;
            }
            deletedIds.add(primitive.getPrimitiveId());
        }
        this.getMergedEntries().addAll(position, newItems);
        this.fireModelDataChanged();
        if (!deletedIds.isEmpty()) {
            this.alertCopyFailedForDeletedPrimitives(deletedIds);
        }
    }

    public void copyAll(ListRole source) {
        this.getMergedEntries().clear();
        int[] rows = IntStream.range(0, this.entries.get((Object)source).size()).toArray();
        this.copy(source, rows, 0);
    }

    protected void copyBeforeCurrent(ListRole source, int[] rows, int current) {
        this.copy(source, rows, current);
        this.mergedEntriesSelectionModel.setSelectionInterval(current, current + rows.length - 1);
    }

    public void copyMyBeforeCurrent(int[] rows, int current) {
        this.copyBeforeCurrent(ListRole.MY_ENTRIES, rows, current);
    }

    public void copyTheirBeforeCurrent(int[] rows, int current) {
        this.copyBeforeCurrent(ListRole.THEIR_ENTRIES, rows, current);
    }

    protected void copyAfterCurrent(ListRole source, int[] rows, int current) {
        this.copy(source, rows, current + 1);
        this.mergedEntriesSelectionModel.setSelectionInterval(current + 1, current + rows.length - 1);
        this.fireStateChanged();
    }

    public void copyMyAfterCurrent(int[] rows, int current) {
        this.copyAfterCurrent(ListRole.MY_ENTRIES, rows, current);
    }

    public void copyTheirAfterCurrent(int[] rows, int current) {
        this.copyAfterCurrent(ListRole.THEIR_ENTRIES, rows, current);
    }

    public void moveUpMerged(int ... rows) {
        if (rows == null || rows.length == 0) {
            return;
        }
        if (rows[0] == 0) {
            return;
        }
        List<T> mergedEntries = this.getMergedEntries();
        for (int row2 : rows) {
            PrimitiveId n = (PrimitiveId)mergedEntries.get(row2);
            mergedEntries.remove(row2);
            mergedEntries.add(row2 - 1, n);
        }
        this.fireModelDataChanged();
        TableHelper.setSelectedIndices(this.mergedEntriesSelectionModel, Arrays.stream(rows).map(row -> row - 1));
    }

    public void moveDownMerged(int ... rows) {
        if (rows == null || rows.length == 0) {
            return;
        }
        List<T> mergedEntries = this.getMergedEntries();
        if (rows[rows.length - 1] == mergedEntries.size() - 1) {
            return;
        }
        for (int i = rows.length - 1; i >= 0; --i) {
            int row2 = rows[i];
            PrimitiveId n = (PrimitiveId)mergedEntries.get(row2);
            mergedEntries.remove(row2);
            mergedEntries.add(row2 + 1, n);
        }
        this.fireModelDataChanged();
        TableHelper.setSelectedIndices(this.mergedEntriesSelectionModel, Arrays.stream(rows).map(row -> row + 1));
    }

    public void removeMerged(int ... rows) {
        if (rows == null || rows.length == 0) {
            return;
        }
        List<T> mergedEntries = this.getMergedEntries();
        for (int i = rows.length - 1; i >= 0; --i) {
            mergedEntries.remove(rows[i]);
        }
        this.fireModelDataChanged();
        this.mergedEntriesSelectionModel.clearSelection();
    }

    protected boolean myAndTheirEntriesEqual() {
        return this.getMyEntriesSize() == this.getTheirEntriesSize() && IntStream.range(0, this.getMyEntriesSize()).allMatch(i -> this.isEqualEntry((PrimitiveId)this.getMyEntries().get(i), (PrimitiveId)this.getTheirEntries().get(i)));
    }

    public ComparePairListModel getComparePairListModel() {
        return this.comparePairListModel;
    }

    public abstract C buildResolveCommand(Conflict<? extends OsmPrimitive> var1);

    public class EntriesTableModel
    extends DefaultTableModel
    implements OsmPrimitivesTableModel {
        private final ListRole role;

        public EntriesTableModel(ListRole role) {
            this.role = role;
        }

        @Override
        public int getRowCount() {
            int count = Math.max(AbstractListMergeModel.this.getMyEntries().size(), AbstractListMergeModel.this.getMergedEntries().size());
            return Math.max(count, AbstractListMergeModel.this.getTheirEntries().size());
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (row < AbstractListMergeModel.this.entries.get((Object)this.role).size()) {
                return AbstractListMergeModel.this.entries.get((Object)this.role).get(row);
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            AbstractListMergeModel.this.setValueAt(this, value, row, col);
        }

        public AbstractListMergeModel<T, C> getListMergeModel() {
            return AbstractListMergeModel.this;
        }

        public boolean isParticipatingInCurrentComparePair() {
            return AbstractListMergeModel.this.getComparePairListModel().getSelectedComparePair().isParticipatingIn(this.role);
        }

        public boolean isSamePositionInOppositeList(int row) {
            if (!this.isParticipatingInCurrentComparePair()) {
                throw new IllegalStateException(I18n.tr("List in role {0} is currently not participating in a compare pair.", this.role.toString()));
            }
            if (row >= this.getEntries().size()) {
                return false;
            }
            if (row >= this.getOppositeEntries().size()) {
                return false;
            }
            PrimitiveId e1 = (PrimitiveId)this.getEntries().get(row);
            PrimitiveId e2 = (PrimitiveId)this.getOppositeEntries().get(row);
            return AbstractListMergeModel.this.isEqualEntry(e1, e2);
        }

        public boolean isIncludedInOppositeList(int row) {
            if (!this.isParticipatingInCurrentComparePair()) {
                throw new IllegalStateException(I18n.tr("List in role {0} is currently not participating in a compare pair.", this.role.toString()));
            }
            if (row >= this.getEntries().size()) {
                return false;
            }
            PrimitiveId e1 = (PrimitiveId)this.getEntries().get(row);
            return this.getOppositeEntries().stream().anyMatch(e2 -> AbstractListMergeModel.this.isEqualEntry(e1, e2));
        }

        protected List<T> getEntries() {
            return AbstractListMergeModel.this.entries.get((Object)this.role);
        }

        protected List<T> getOppositeEntries() {
            ListRole opposite = AbstractListMergeModel.this.getComparePairListModel().getSelectedComparePair().getOppositeRole(this.role);
            return AbstractListMergeModel.this.entries.get((Object)opposite);
        }

        public ListRole getRole() {
            return this.role;
        }

        @Override
        public OsmPrimitive getReferredPrimitive(int idx) {
            Object value = this.getValueAt(idx, 1);
            if (value instanceof OsmPrimitive) {
                return (OsmPrimitive)value;
            }
            if (value instanceof RelationMember) {
                return ((RelationMember)value).getMember();
            }
            Logging.error("Unknown object type: " + value);
            return null;
        }
    }

    protected class EntriesSelectionModel
    extends DefaultListSelectionModel {
        private final transient List<T> entries;

        public EntriesSelectionModel(List<T> nodes) {
            this.entries = nodes;
        }

        @Override
        public void addSelectionInterval(int index0, int index1) {
            if (this.entries.isEmpty()) {
                return;
            }
            if (index0 > this.entries.size() - 1) {
                return;
            }
            index0 = Math.min(this.entries.size() - 1, index0);
            index1 = Math.min(this.entries.size() - 1, index1);
            super.addSelectionInterval(index0, index1);
        }

        @Override
        public void insertIndexInterval(int index, int length, boolean before) {
            if (this.entries.isEmpty()) {
                return;
            }
            if (before) {
                int newindex = Math.min(this.entries.size() - 1, index);
                if (newindex < index - length) {
                    return;
                }
                super.insertIndexInterval(newindex, length -= index - newindex, before);
            } else {
                if (index > this.entries.size() - 1) {
                    return;
                }
                length = Math.min(this.entries.size() - 1 - index, length);
                super.insertIndexInterval(index, length, before);
            }
        }

        @Override
        public void moveLeadSelectionIndex(int leadIndex) {
            if (this.entries.isEmpty()) {
                return;
            }
            leadIndex = Math.max(0, leadIndex);
            leadIndex = Math.min(this.entries.size() - 1, leadIndex);
            super.moveLeadSelectionIndex(leadIndex);
        }

        @Override
        public void removeIndexInterval(int index0, int index1) {
            if (this.entries.isEmpty()) {
                return;
            }
            index0 = Math.max(0, index0);
            index0 = Math.min(this.entries.size() - 1, index0);
            index1 = Math.max(0, index1);
            index1 = Math.min(this.entries.size() - 1, index1);
            super.removeIndexInterval(index0, index1);
        }

        @Override
        public void removeSelectionInterval(int index0, int index1) {
            if (this.entries.isEmpty()) {
                return;
            }
            index0 = Math.max(0, index0);
            index0 = Math.min(this.entries.size() - 1, index0);
            index1 = Math.max(0, index1);
            index1 = Math.min(this.entries.size() - 1, index1);
            super.removeSelectionInterval(index0, index1);
        }

        @Override
        public void setAnchorSelectionIndex(int anchorIndex) {
            if (this.entries.isEmpty()) {
                return;
            }
            anchorIndex = Math.min(this.entries.size() - 1, anchorIndex);
            super.setAnchorSelectionIndex(anchorIndex);
        }

        @Override
        public void setLeadSelectionIndex(int leadIndex) {
            if (this.entries.isEmpty()) {
                return;
            }
            leadIndex = Math.min(this.entries.size() - 1, leadIndex);
            super.setLeadSelectionIndex(leadIndex);
        }

        @Override
        public void setSelectionInterval(int index0, int index1) {
            if (this.entries.isEmpty()) {
                return;
            }
            index0 = Math.max(0, index0);
            index0 = Math.min(this.entries.size() - 1, index0);
            index1 = Math.max(0, index1);
            index1 = Math.min(this.entries.size() - 1, index1);
            super.setSelectionInterval(index0, index1);
        }
    }

    public class ComparePairListModel
    extends JosmComboBoxModel<ComparePairType> {
        private int selectedIdx;
        private final List<ComparePairType> compareModes = new ArrayList<ComparePairType>();

        public ComparePairListModel() {
            this.compareModes.add(ComparePairType.MY_WITH_THEIR);
            this.compareModes.add(ComparePairType.MY_WITH_MERGED);
            this.compareModes.add(ComparePairType.THEIR_WITH_MERGED);
            this.selectedIdx = 0;
        }

        @Override
        public ComparePairType getElementAt(int index) {
            if (index < this.compareModes.size()) {
                return this.compareModes.get(index);
            }
            throw new IllegalArgumentException(I18n.tr("Unexpected value of parameter ''index''. Got {0}.", index));
        }

        @Override
        public int getSize() {
            return this.compareModes.size();
        }

        @Override
        public Object getSelectedItem() {
            return this.compareModes.get(this.selectedIdx);
        }

        @Override
        public void setSelectedItem(Object anItem) {
            int i = this.compareModes.indexOf(anItem);
            if (i < 0) {
                throw new IllegalStateException(I18n.tr("Item {0} not found in list.", anItem));
            }
            this.selectedIdx = i;
            AbstractListMergeModel.this.fireModelDataChanged();
        }

        public ComparePairType getSelectedComparePair() {
            return this.compareModes.get(this.selectedIdx);
        }
    }
}

