/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor.paint;

import java.awt.Graphics2D;
import java.lang.reflect.Constructor;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openstreetmap.josm.data.osm.visitor.paint.AbstractMapRenderer;
import org.openstreetmap.josm.data.osm.visitor.paint.StyledMapRenderer;
import org.openstreetmap.josm.data.osm.visitor.paint.WireframeMapRenderer;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public final class MapRendererFactory {
    public static final String PREF_KEY_RENDERER_CLASS_NAME = "mappaint.renderer-class-name";
    private static MapRendererFactory instance;
    private final List<Descriptor> descriptors = new ArrayList<Descriptor>();
    private Class<? extends AbstractMapRenderer> activeRenderer;

    public static synchronized MapRendererFactory getInstance() {
        if (instance == null) {
            instance = new MapRendererFactory();
        }
        return instance;
    }

    private static Class<?> loadRendererClass(String className) {
        for (ClassLoader cl : PluginHandler.getResourceClassLoaders()) {
            try {
                return Class.forName(className, true, cl);
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                Logging.trace(e);
            }
        }
        Logging.error(I18n.tr("Failed to load map renderer class ''{0}''. The class wasn''t found.", className));
        return null;
    }

    private MapRendererFactory() {
        this.registerDefaultRenderers();
        String rendererClassName = Config.getPref().get(PREF_KEY_RENDERER_CLASS_NAME, null);
        if (rendererClassName != null) {
            this.activateMapRenderer(rendererClassName);
        } else {
            this.activateDefault();
        }
    }

    private void activateMapRenderer(String rendererClassName) {
        Class<?> c = MapRendererFactory.loadRendererClass(rendererClassName);
        if (c == null) {
            Logging.error(I18n.tr("Can''t activate map renderer class ''{0}'', because the class wasn''t found.", rendererClassName));
            Logging.error(I18n.tr("Activating the standard map renderer instead.", new Object[0]));
            this.activateDefault();
        } else if (!AbstractMapRenderer.class.isAssignableFrom(c)) {
            Logging.error(I18n.tr("Can''t activate map renderer class ''{0}'', because it isn''t a subclass of ''{1}''.", rendererClassName, AbstractMapRenderer.class.getName()));
            Logging.error(I18n.tr("Activating the standard map renderer instead.", new Object[0]));
            this.activateDefault();
        } else {
            Class<AbstractMapRenderer> renderer = c.asSubclass(AbstractMapRenderer.class);
            if (!this.isRegistered(renderer)) {
                Logging.error(I18n.tr("Can''t activate map renderer class ''{0}'', because it isn''t registered as map renderer.", rendererClassName));
                Logging.error(I18n.tr("Activating the standard map renderer instead.", new Object[0]));
                this.activateDefault();
            } else {
                this.activate(renderer);
            }
        }
    }

    private void registerDefaultRenderers() {
        this.register(WireframeMapRenderer.class, I18n.tr("Wireframe Map Renderer", new Object[0]), I18n.tr("Renders the map as simple wire frame.", new Object[0]));
        this.register(StyledMapRenderer.class, I18n.tr("Styled Map Renderer", new Object[0]), I18n.tr("Renders the map using style rules in a set of style sheets.", new Object[0]));
    }

    public boolean isRegistered(Class<? extends AbstractMapRenderer> renderer) {
        CheckParameterUtil.ensureParameterNotNull(renderer);
        return this.descriptors.stream().anyMatch(d -> d.getRenderer().equals(renderer));
    }

    public void register(Class<? extends AbstractMapRenderer> renderer, String displayName, String description) {
        CheckParameterUtil.ensureParameterNotNull(renderer);
        if (this.isRegistered(renderer)) {
            throw new IllegalStateException(MessageFormat.format("Class ''{0}'' already registered a renderer", renderer.getName()));
        }
        Descriptor d = new Descriptor(renderer, displayName, description);
        this.descriptors.add(d);
    }

    public void unregister(Class<? extends AbstractMapRenderer> renderer) {
        if (renderer == null) {
            return;
        }
        if (!this.isRegistered(renderer)) {
            return;
        }
        this.descriptors.removeIf(d -> d.getRenderer().equals(renderer));
        if (this.activeRenderer != null && this.activeRenderer.equals(renderer)) {
            this.activateDefault();
        }
    }

    public void activate(Class<? extends AbstractMapRenderer> renderer) {
        CheckParameterUtil.ensureParameterNotNull(renderer);
        if (!this.isRegistered(renderer)) {
            throw new IllegalStateException(MessageFormat.format("Class ''{0}'' not registered as renderer. Can''t activate it.", renderer.getName()));
        }
        this.activeRenderer = renderer;
        Config.getPref().put(PREF_KEY_RENDERER_CLASS_NAME, this.activeRenderer.getName());
    }

    public void activateDefault() {
        Class<StyledMapRenderer> defaultRenderer = StyledMapRenderer.class;
        if (!this.isRegistered(defaultRenderer)) {
            throw new IllegalStateException(MessageFormat.format("Class ''{0}'' not registered as renderer. Can''t activate default renderer.", defaultRenderer.getName()));
        }
        this.activate(defaultRenderer);
    }

    public AbstractMapRenderer createActiveRenderer(Graphics2D g, NavigatableComponent viewport, boolean isInactiveMode) {
        try {
            Constructor<? extends AbstractMapRenderer> c = this.activeRenderer.getConstructor(Graphics2D.class, NavigatableComponent.class, Boolean.TYPE);
            return (AbstractMapRenderer)AbstractMapRenderer.class.cast(c.newInstance(g, viewport, isInactiveMode));
        }
        catch (IllegalArgumentException | ReflectiveOperationException e) {
            throw new MapRendererFactoryException(e);
        }
    }

    public List<Descriptor> getMapRendererDescriptors() {
        return Collections.unmodifiableList(this.descriptors);
    }

    public boolean isWireframeMapRendererActive() {
        return WireframeMapRenderer.class.equals(this.activeRenderer);
    }

    public static class Descriptor {
        private final Class<? extends AbstractMapRenderer> renderer;
        private final String displayName;
        private final String description;

        public Descriptor(Class<? extends AbstractMapRenderer> renderer, String displayName, String description) {
            this.renderer = renderer;
            this.displayName = displayName;
            this.description = description;
        }

        public Class<? extends AbstractMapRenderer> getRenderer() {
            return this.renderer;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getDescription() {
            return this.description;
        }
    }

    public static class MapRendererFactoryException
    extends RuntimeException {
        public MapRendererFactoryException(String message, Throwable cause) {
            super(message, cause);
        }

        public MapRendererFactoryException(String message) {
            super(message);
        }

        public MapRendererFactoryException(Throwable cause) {
            super(cause);
        }
    }
}

