/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.Tagged;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class TagCollection
implements Iterable<Tag>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<Tag, Integer> tags = new HashMap<Tag, Integer>();
    private static final Pattern SPLIT_VALUES_PATTERN = Pattern.compile(";\\s*");

    public static TagCollection from(Tagged primitive) {
        TagCollection tags = new TagCollection();
        if (primitive != null) {
            primitive.visitKeys((p, key, value) -> tags.add(new Tag(key, value)));
        }
        return tags;
    }

    public static TagCollection from(Map<String, String> tags) {
        TagCollection ret = new TagCollection();
        if (tags == null) {
            return ret;
        }
        for (Map.Entry<String, String> entry : tags.entrySet()) {
            String key = entry.getKey() == null ? "" : entry.getKey();
            String value = entry.getValue() == null ? "" : entry.getValue();
            ret.add(new Tag(key, value));
        }
        return ret;
    }

    public static TagCollection unionOfAllPrimitives(Collection<? extends Tagged> primitives) {
        TagCollection tags = new TagCollection();
        if (primitives == null) {
            return tags;
        }
        for (Tagged tagged : primitives) {
            if (tagged == null) continue;
            tags.add(TagCollection.from(tagged));
        }
        return tags;
    }

    public static TagCollection commonToAllPrimitives(Collection<? extends Tagged> primitives) {
        TagCollection tags = new TagCollection();
        if (primitives == null || primitives.isEmpty()) {
            return tags;
        }
        tags.add(TagCollection.from(primitives.iterator().next()));
        for (Tagged tagged : primitives) {
            if (tagged != null && (tags = tags.intersect(TagCollection.from(tagged))).isEmpty()) break;
        }
        return tags;
    }

    public static TagCollection unionOfAllPrimitives(DataSet ds) {
        TagCollection tags = new TagCollection();
        if (ds == null) {
            return tags;
        }
        tags.add(TagCollection.unionOfAllPrimitives(ds.allPrimitives()));
        return tags;
    }

    public TagCollection() {
    }

    public TagCollection(TagCollection other) {
        if (other != null) {
            this.tags.putAll(other.tags);
        }
    }

    public TagCollection(Collection<Tag> tags) {
        this.add(tags);
    }

    public int size() {
        return this.tags.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public final void add(Tag tag) {
        if (tag != null) {
            this.tags.merge(tag, 1, (i, j) -> i + j);
        }
    }

    public int getTagOccurrence(Tag tag) {
        return this.tags.getOrDefault(tag, 0);
    }

    public final void add(Collection<Tag> tags) {
        if (tags == null) {
            return;
        }
        for (Tag tag : tags) {
            this.add(tag);
        }
    }

    public final void add(TagCollection tags) {
        if (tags != null) {
            for (Map.Entry<Tag, Integer> entry : tags.tags.entrySet()) {
                this.tags.merge(entry.getKey(), entry.getValue(), (i, j) -> i + j);
            }
        }
    }

    public void remove(Tag tag) {
        if (tag == null) {
            return;
        }
        this.tags.remove(tag);
    }

    public void remove(Collection<Tag> tags) {
        if (tags != null) {
            tags.forEach(this::remove);
        }
    }

    public void remove(TagCollection tags) {
        if (tags != null) {
            tags.tags.keySet().forEach(this::remove);
        }
    }

    public void removeByKey(String key) {
        if (key != null) {
            this.tags.keySet().removeIf(tag -> tag.matchesKey(key));
        }
    }

    public void removeByKey(Collection<String> keys) {
        if (keys == null) {
            return;
        }
        for (String key : keys) {
            this.removeByKey(key);
        }
    }

    public boolean contains(Tag tag) {
        return this.tags.containsKey(tag);
    }

    public boolean containsAll(Collection<Tag> tags) {
        if (tags == null) {
            return false;
        }
        return this.tags.keySet().containsAll(tags);
    }

    public boolean containsAllKeys(Collection<String> keys) {
        if (keys == null) {
            return false;
        }
        return keys.stream().filter(Objects::nonNull).allMatch(this::hasTagsFor);
    }

    public int getNumTagsFor(String key) {
        return (int)this.generateStreamForKey(key).count();
    }

    public boolean hasTagsFor(String key) {
        return this.getNumTagsFor(key) > 0;
    }

    public boolean hasValuesFor(String key) {
        return this.generateStreamForKey(key).anyMatch(t -> !t.getValue().isEmpty());
    }

    public boolean hasUniqueNonEmptyValue(String key) {
        return this.generateStreamForKey(key).filter(t -> !t.getValue().isEmpty()).count() == 1L;
    }

    public boolean hasEmptyValue(String key) {
        return this.generateStreamForKey(key).anyMatch(t -> t.getValue().isEmpty());
    }

    public boolean hasUniqueEmptyValue(String key) {
        Set<String> values = this.getValues(key);
        return values.size() == 1 && values.contains("");
    }

    public TagCollection getTagsFor(String key) {
        TagCollection ret = new TagCollection();
        this.generateStreamForKey(key).forEach(ret::add);
        return ret;
    }

    public TagCollection getTagsFor(Collection<String> keys) {
        TagCollection ret = new TagCollection();
        if (keys == null) {
            return ret;
        }
        for (String key : keys) {
            if (key == null) continue;
            ret.add(this.getTagsFor(key));
        }
        return ret;
    }

    public Set<Tag> asSet() {
        return new HashSet<Tag>(this.tags.keySet());
    }

    public List<Tag> asList() {
        return new ArrayList<Tag>(this.tags.keySet());
    }

    @Override
    public Iterator<Tag> iterator() {
        return this.tags.keySet().iterator();
    }

    public Set<String> getKeys() {
        return this.generateKeyStream().collect(Collectors.toCollection(HashSet::new));
    }

    public Set<String> getKeysWithMultipleValues() {
        HashSet singleKeys = new HashSet();
        return this.generateKeyStream().filter(key -> !singleKeys.add(key)).collect(Collectors.toSet());
    }

    public void setUniqueForKey(Tag tag) {
        if (tag == null) {
            return;
        }
        this.removeByKey(tag.getKey());
        this.add(tag);
    }

    public void setUniqueForKey(String key, String value) {
        Tag tag = new Tag(key, value);
        this.setUniqueForKey(tag);
    }

    public Set<String> getValues() {
        return this.tags.keySet().stream().map(Tag::getValue).collect(Collectors.toSet());
    }

    public Set<String> getValues(String key) {
        return this.generateStreamForKey(key).map(Tag::getValue).collect(Collectors.toSet());
    }

    public boolean isApplicableToPrimitive() {
        return this.getKeysWithMultipleValues().isEmpty();
    }

    public void applyTo(Tagged primitive) {
        if (primitive == null) {
            return;
        }
        this.ensureApplicableToPrimitive();
        for (Tag tag : this.tags.keySet()) {
            if (tag.getValue() == null || tag.getValue().isEmpty()) {
                primitive.remove(tag.getKey());
                continue;
            }
            primitive.put(tag.getKey(), tag.getValue());
        }
    }

    public void applyTo(Collection<? extends Tagged> primitives) {
        if (primitives == null) {
            return;
        }
        this.ensureApplicableToPrimitive();
        for (Tagged tagged : primitives) {
            this.applyTo(tagged);
        }
    }

    public void replaceTagsOf(Tagged primitive) {
        if (primitive == null) {
            return;
        }
        this.ensureApplicableToPrimitive();
        primitive.removeAll();
        for (Tag tag : this.tags.keySet()) {
            primitive.put(tag.getKey(), tag.getValue());
        }
    }

    public void replaceTagsOf(Collection<? extends Tagged> primitives) {
        if (primitives == null) {
            return;
        }
        this.ensureApplicableToPrimitive();
        for (Tagged tagged : primitives) {
            this.replaceTagsOf(tagged);
        }
    }

    private void ensureApplicableToPrimitive() {
        if (!this.isApplicableToPrimitive()) {
            throw new IllegalStateException(I18n.tr("Tag collection cannot be applied to a primitive because there are keys with multiple values.", new Object[0]));
        }
    }

    public TagCollection intersect(TagCollection other) {
        TagCollection ret = new TagCollection();
        if (other != null) {
            this.tags.keySet().stream().filter(other::contains).forEach(ret::add);
        }
        return ret;
    }

    public TagCollection minus(TagCollection other) {
        TagCollection ret = new TagCollection(this);
        if (other != null) {
            ret.remove(other);
        }
        return ret;
    }

    public TagCollection union(TagCollection other) {
        TagCollection ret = new TagCollection(this);
        if (other != null) {
            ret.add(other);
        }
        return ret;
    }

    public TagCollection emptyTagsForKeysMissingIn(TagCollection other) {
        TagCollection ret = new TagCollection();
        for (String key : this.minus(other).getKeys()) {
            ret.add(new Tag(key));
        }
        return ret;
    }

    public String getJoinedValues(String key) {
        Set<String> originalValues = this.getValues(key);
        if (originalValues.size() == 1) {
            return originalValues.iterator().next();
        }
        LinkedHashSet<String> values = new LinkedHashSet<String>();
        LinkedHashMap<String, List<String>> originalSplitValues = new LinkedHashMap<String, List<String>>();
        for (String string : originalValues) {
            List<String> vs = Arrays.asList(SPLIT_VALUES_PATTERN.split(string, -1));
            originalSplitValues.put(string, vs);
            values.addAll(vs);
        }
        values.remove("");
        for (Map.Entry entry : originalSplitValues.entrySet()) {
            if (!((Collection)entry.getValue()).containsAll(values)) continue;
            return (String)entry.getKey();
        }
        return String.join((CharSequence)";", values);
    }

    public String getSummedValues(String key) {
        int result = 0;
        for (String value : this.getValues(key)) {
            try {
                result += Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                Logging.trace(e);
            }
        }
        return Integer.toString(result);
    }

    private Stream<String> generateKeyStream() {
        return this.tags.keySet().stream().map(Tag::getKey);
    }

    private Stream<Tag> generateStreamForKey(String key) {
        return this.tags.keySet().stream().filter(e -> e.matchesKey(key));
    }

    public String toString() {
        return this.tags.toString();
    }
}

