/*
 * Decompiled with CFR 0.152.
 */
package uru;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import shared.FileUtils;
import shared.m;

public class reflection {
    public static Class[] blacklist = new Class[]{Class.class};

    public static String reflectionReportText(Object obj) {
        StringBuilder result = new StringBuilder();
        reflection.deepReflectionReportText(obj, obj.getClass(), result, 0);
        return result.toString();
    }

    static void depthString(StringBuilder result, int depth) {
        for (int i = 0; i < depth; ++i) {
            result.append("  ");
        }
    }

    public static void deepReflectionReportText(Object obj, Class objclass, StringBuilder result, int depth) {
        try {
            if (depth == 42) {
                int n = 3;
            }
            if (objclass.isPrimitive() || objclass == String.class || objclass.isEnum()) {
                reflection.depthString(result, depth);
                result.append("type:" + objclass.getName() + " value:" + obj.toString() + "\n");
            } else if (objclass.isArray()) {
                reflection.depthString(result, depth);
                result.append("type:" + objclass.getName() + " array elements:\n");
                int length = Array.getLength(obj);
                for (int i = 0; i < length; ++i) {
                    Object arrayitem = Array.get(obj, i);
                    reflection.deepReflectionReportText(arrayitem, arrayitem.getClass(), result, depth + 1);
                }
            } else {
                if (objclass == Class.class) {
                    return;
                }
                reflection.depthString(result, depth);
                result.append("type:" + objclass.getName() + " class members:\n");
                if (objclass.getSuperclass() != Object.class) {
                    // empty if block
                }
                AccessibleObject[] fields = objclass.getDeclaredFields();
                AccessibleObject.setAccessible(fields, true);
                for (int i = 0; i < fields.length; ++i) {
                    Class<?> curclass = ((Field)fields[i]).getType();
                    Object curfield = ((Field)fields[i]).get(obj);
                    reflection.deepReflectionReportText(curfield, curclass, result, depth + 1);
                }
            }
        }
        catch (Exception e2) {
            m.err("Error creating report.");
        }
    }

    public static void reflectionReportToFile(Object obj, String outfolder) {
        String report = reflection.reflectionReportXml(obj);
        byte[] report2 = report.getBytes();
        FileUtils.WriteFile(outfolder + "/reflectionreport.xml", report2);
    }

    public static String reflectionReportXml(Object obj) {
        StringBuilder result = new StringBuilder();
        reflection.deepReflectionReportXml(obj, result, 0);
        return result.toString();
    }

    public static String sane(Class s) {
        String result = s.getSimpleName();
        result = result.replace(';', '_');
        result = result.replace('$', '_');
        result = result.replace('.', '_');
        result = result.replace('[', '_');
        result = result.replace(']', '_');
        return result;
    }

    public static String sane2(String s) {
        String result = s;
        result = result.replace('<', '_');
        result = result.replace('>', '_');
        result = result.replace('&', '_');
        return result;
    }

    public static void deepReflectionReportXml(Object obj, StringBuilder result, int depth) {
        try {
            if (obj == null) {
                result.append("<null />");
                return;
            }
            Class<?> objclass = obj.getClass();
            String classname = reflection.sane(objclass);
            if (depth >= 8) {
                return;
            }
            for (int i = 0; i < blacklist.length; ++i) {
                if (blacklist[i] != objclass) continue;
                return;
            }
            if (objclass.isPrimitive() || objclass == String.class || objclass.isEnum() || objclass == Integer.class || objclass == Short.class || objclass == Byte.class) {
                result.append("<" + classname + ">" + reflection.sane2(obj.toString()) + "</" + classname + ">");
            } else if (objclass.isArray()) {
                result.append("<array" + classname + ">");
                int length = Array.getLength(obj);
                for (int i = 0; i < length; ++i) {
                    Object arrayitem = Array.get(obj, i);
                    reflection.deepReflectionReportXml(arrayitem, result, depth + 1);
                }
                result.append("</array" + classname + ">");
            } else {
                result.append("<" + classname + ">");
                if (objclass.getSuperclass() != Object.class) {
                    // empty if block
                }
                AccessibleObject[] fields = objclass.getDeclaredFields();
                AccessibleObject.setAccessible(fields, true);
                for (int i = 0; i < fields.length; ++i) {
                    Class<?> curclass = ((Field)fields[i]).getType();
                    Object curfield = ((Field)fields[i]).get(obj);
                    reflection.deepReflectionReportXml(curfield, result, depth + 1);
                }
                result.append("</" + classname + ">");
            }
        }
        catch (Exception e2) {
            m.err("Error creating report.");
            e2.printStackTrace();
        }
    }
}

