/*
 * Decompiled with CFR 0.152.
 */
package shared;

import dust.com.sun.java.swing.plaf.motif.MotifScrollBarButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTabbedPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import shared.cancel;
import shared.m;
import shared.translation;

public class GuiThread {
    public static void run(GuiThreadInfo info, Runnable command) {
        try {
            if (info.setWorkingProgressBar) {
                m.setWorking(true);
            }
            if (info.useGlassPane) {
                GuiThread.runGlass(info, command);
            } else {
                GuiThread.runModal(info, command);
            }
        }
        catch (cancel e2) {
            m.status("Cancelled because of an error.");
        }
    }

    private static void runGlass(GuiThreadInfo info, Runnable command) {
        InvisibleThread thread = new InvisibleThread(command, info);
        for (RootPaneContainer rootpane : info.rootpanes) {
            Container contentPane = rootpane.getContentPane();
            InvisibleGlassPane glasspane = new InvisibleGlassPane(contentPane, info);
            thread.addModal(glasspane);
            rootpane.setGlassPane(glasspane);
            glasspane.setVisible(true);
        }
        thread.start();
    }

    private static void runModal(GuiThreadInfo info, Runnable command) {
        final InvisibleModal modal = new InvisibleModal();
        InvisibleThread thread = new InvisibleThread(command, info);
        thread.addModal(modal);
        Thread modalthread = new Thread(new Runnable(){

            @Override
            public void run() {
                modal.setVisible(true);
            }
        });
        modalthread.start();
        thread.start();
    }

    private static class InvisibleGlassPane
    extends JPanel
    implements MouseListener,
    FocusListener,
    MouseMotionListener,
    KeyListener,
    ComponentListener {
        Component contentPane;

        public InvisibleGlassPane(Component contentPane, GuiThreadInfo info) {
            this.contentPane = contentPane;
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.addFocusListener(this);
            this.addKeyListener(this);
            this.addComponentListener(this);
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            if (info.setWorkingText) {
                JLabel label = new JLabel(translation.translate("Working..."), 0);
                label.setFont(label.getFont().deriveFont(60.0f));
                label.setForeground(Color.DARK_GRAY);
                this.add((Component)label, "Center");
                label.setNextFocusableComponent(label);
            }
        }

        @Override
        public void componentResized(ComponentEvent e2) {
        }

        @Override
        public void componentMoved(ComponentEvent e2) {
        }

        @Override
        public void componentShown(ComponentEvent e2) {
            boolean likelytosucceed = this.requestFocusInWindow();
            boolean dummy = false;
        }

        @Override
        public void componentHidden(ComponentEvent e2) {
        }

        @Override
        public void keyTyped(KeyEvent e2) {
            boolean dummy = false;
        }

        @Override
        public void keyPressed(KeyEvent e2) {
            boolean dummy = false;
        }

        @Override
        public void keyReleased(KeyEvent e2) {
            boolean dummy = false;
        }

        @Override
        public void mouseClicked(MouseEvent e2) {
            this.redispatch(e2);
        }

        @Override
        public void mousePressed(MouseEvent e2) {
            this.redispatch(e2);
        }

        @Override
        public void mouseReleased(MouseEvent e2) {
            this.redispatch(e2);
        }

        @Override
        public void mouseEntered(MouseEvent e2) {
            this.redispatch(e2);
        }

        @Override
        public void mouseExited(MouseEvent e2) {
            this.redispatch(e2);
        }

        @Override
        public void focusLost(FocusEvent fe) {
        }

        @Override
        public void focusGained(FocusEvent fe) {
        }

        @Override
        public void mouseDragged(MouseEvent e2) {
            this.redispatch(e2);
        }

        @Override
        public void mouseMoved(MouseEvent e2) {
        }

        public void redispatch(MouseEvent e2) {
            boolean sendclick = false;
            Point glassPanePoint = e2.getPoint();
            Point containerPoint = SwingUtilities.convertPoint(this, glassPanePoint, this.contentPane);
            Component comp = SwingUtilities.getDeepestComponentAt(this.contentPane, containerPoint.x, containerPoint.y);
            if (comp != null && (comp instanceof JTabbedPane || comp instanceof JScrollBar || comp instanceof MotifScrollBarButton)) {
                sendclick = true;
            }
            if (sendclick) {
                Point componentPoint = SwingUtilities.convertPoint(this, glassPanePoint, comp);
                comp.dispatchEvent(new MouseEvent(comp, e2.getID(), e2.getWhen(), e2.getModifiers(), componentPoint.x, componentPoint.y, e2.getClickCount(), e2.isPopupTrigger()));
            }
        }
    }

    private static class InvisibleModal
    extends JDialog {
        public InvisibleModal() {
            this.setDefaultCloseOperation(2);
            this.setModal(true);
            this.setResizable(false);
            this.setUndecorated(true);
            this.setSize(0, 0);
        }
    }

    private static class InvisibleThread
    extends Thread {
        Runnable command;
        Vector<Component> modal = new Vector();
        GuiThreadInfo info;

        public InvisibleThread(Runnable command2, GuiThreadInfo info22) {
            this.command = command2;
            this.info = info22;
        }

        public void addModal(Component modal2) {
            this.modal.add(modal2);
        }

        @Override
        public void run() {
            try {
                this.command.run();
            }
            catch (Exception e2) {
                m.err("Unexpected error in GuiThread:");
                e2.printStackTrace();
            }
            for (Component comp : this.modal) {
                comp.setVisible(false);
            }
            if (this.info.setWorkingProgressBar) {
                m.setWorking(false);
            }
        }
    }

    public static class GuiThreadInfo {
        public boolean useGlassPane = true;
        public Vector<RootPaneContainer> rootpanes = new Vector();
        public boolean setWorkingProgressBar = true;
        public boolean setWorkingText = true;
    }
}

