/*
 * Decompiled with CFR 0.152.
 */
package prpobjects;

import java.io.Serializable;
import org.w3c.dom.Element;
import prpobjects.uruobj;
import shared.Format;
import shared.IBytestream;
import shared.b;
import shared.e;
import shared.m;
import shared.xml;
import uru.Bytedeque;
import uru.context;

public class Urustring
extends uruobj
implements Serializable {
    byte[] unencryptedString;

    public static Urustring createFromString(String s) {
        Urustring result = new Urustring();
        result.unencryptedString = b.StringToBytes(s);
        return result;
    }

    private Urustring() {
    }

    public void shallowCopyFrom(Urustring s2) {
        this.unencryptedString = s2.unencryptedString;
    }

    public Urustring(IBytestream c, int readversion) {
        if (readversion == 6 || readversion == 3 || readversion == 8) {
            short lengthbytes = c.readShort();
            if ((lengthbytes & 0xF000) == 0) {
                c.readShort();
            }
            int actuallength = lengthbytes & 0xFFF;
            if ((lengthbytes & 0xF000) != 61440) {
                m.msg("urustring doesn't start with F.");
            }
            if (actuallength > 255) {
                m.msg("urustring over 255 bytes.");
            }
            this.unencryptedString = new byte[actuallength];
            if (actuallength > 0) {
                byte b0 = c.readByte();
                if ((b0 & 0x80) != 0) {
                    this.unencryptedString[0] = ~b0;
                    for (int i = 1; i < actuallength; ++i) {
                        this.unencryptedString[i] = ~c.readByte();
                    }
                } else {
                    if (actuallength != 0) {
                        m.msg("urustring is not encrypted.");
                    }
                    this.unencryptedString[0] = b0;
                    for (int i = 1; i < actuallength; ++i) {
                        this.unencryptedString[i] = c.readByte();
                    }
                }
            }
        } else if (readversion == 4 || readversion == 7) {
            byte[] key = new byte[]{109, 121, 115, 116, 110, 101, 114, 100};
            int len = c.readShort();
            byte[] result = new byte[len];
            for (int i = 0; i < len; ++i) {
                result[i] = (byte)(c.readByte() ^ key[i % 8]);
            }
            this.unencryptedString = result;
        }
        e.ensureString(this.unencryptedString);
    }

    public Urustring(context c) {
        this(c.in, c.readversion);
    }

    @Override
    public void compile(Bytedeque deque) {
        if (deque.format == Format.pots || deque.format == Format.moul) {
            int actuallength = this.unencryptedString.length;
            short startint = (short)(0xF000 | actuallength);
            byte[] startbytes = b.Int16ToBytes(startint);
            deque.writeBytes(startbytes);
            for (int i = 0; i < actuallength; ++i) {
                deque.writeByte(~this.unencryptedString[i]);
            }
        } else {
            m.throwUncaughtException("unimplemented");
        }
    }

    public String toString() {
        return new String(this.unencryptedString);
    }

    public Urustring(byte[] unencrypted) {
        this.unencryptedString = unencrypted;
    }

    public void addXml(StringBuilder s) {
        s.append(xml.sanitise(this.toString()));
    }

    public static Urustring createFromXml(Element e1) {
        return Urustring.createFromString(e1.getTextContent());
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof Urustring)) {
            return false;
        }
        return o.toString().equals(this.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public Urustring deepClone() {
        Urustring result = new Urustring();
        result.unencryptedString = b.CopyBytes(this.unencryptedString);
        return result;
    }
}

