/*
 * Decompiled with CFR 0.152.
 */
package auto;

import auto.AllGames;
import auto.postmod.PostMod_RemoveDynamicCamMap;
import java.io.File;
import java.util.HashMap;
import prpobjects.Typeid;
import prpobjects.Urustring;
import prpobjects.prpfile;
import prpobjects.sumfile;
import prpobjects.textfile;
import shared.FileUtils;
import shared.IBytestream;
import shared.MemUtils;
import shared.SerialBytestream;
import shared.cmap;
import shared.m;
import uru.UruCrypt;
import uru.context;

public class conversion {
    public static void convertFiles(Info info) {
        for (FileInfo file : info.g.allfiles) {
            conversion.convertFile(info, file);
        }
    }

    public static void convertFile(Info info, FileInfo file) {
        switch (file.type) {
            case fni: {
                conversion.convertFni(info, file);
                break;
            }
            case sum: {
                conversion.convertSum(info, file);
                break;
            }
            case age: {
                conversion.convertAge(info, file);
                break;
            }
            case prp: {
                conversion.convertPrp(info, file);
                break;
            }
            case ogg: {
                conversion.convertOgg(info, file);
                break;
            }
            case bik: {
                conversion.convertBik(info, file);
                break;
            }
            case csv: {
                conversion.convertCsv(info, file);
                break;
            }
            default: {
                m.err("Cannot convert this file type: ", file.type.toString());
            }
        }
    }

    public static void convertPrp(Info info, FileInfo file) {
        String newAgename;
        cmap<Integer, Integer> suffix;
        String infile = info.infolder + "/dat/" + file.filename;
        IBytestream bytestream = SerialBytestream.createFromFilename(infile);
        context c = context.createFromBytestream(bytestream);
        c.curFile = file.filename;
        c.realreadversion = info.g.game.readversion;
        Integer prefix = info.g.renameinfo.prefices.get(file.agename);
        if (prefix != null) {
            c.sequencePrefix = prefix;
        }
        if ((suffix = info.g.renameinfo.pagenums.get(file.agename)) != null) {
            c.pagenumMap = suffix;
        }
        if ((newAgename = info.g.renameinfo.agenames.get(file.agename)) != null) {
            c.ageName = newAgename;
        }
        Typeid[] typesToRead = null;
        prpfile prp = prpfile.createFromContext(c, typesToRead);
        String oldpagename = prp.header.pagename.toString();
        String newpagename = (String)info.g.renameinfo.pagenames.get2(file.agename, prp.header.pagename.toString());
        if (newpagename != null) {
            prp.header.pagename = Urustring.createFromString(newpagename);
        }
        String oldagename = prp.header.agename.toString();
        String newagename = info.g.renameinfo.agenames.get(file.agename);
        if (newagename != null) {
            prp.header.agename = Urustring.createFromString(newagename);
            PostMod_RemoveDynamicCamMap.PostMod_ChangeVerySpecialPython(prp, oldagename, newagename);
        }
        if (info.g.prpmodifier != null) {
            info.g.prpmodifier.ModifyPrp(info, file, prp);
        }
        String outfile = info.outfolder + "/dat/" + prp.header.agename.toString() + "_District_" + prp.header.pagename.toString() + ".prp";
        prp.saveAsBytes(info.g.decider).writeAllBytesToFile(outfile);
        c.close();
        MemUtils.GarbageCollect();
    }

    public static void convertOgg(Info info, FileInfo file) {
        String infile = info.infolder + "/sfx/" + file.filename;
        String outfile = info.outfolder + "/sfx/" + info.g.renameinfo.simplefilesrename(file.filename);
        FileUtils.CopyFile(infile, outfile, true, true);
    }

    public static void convertAge(Info info, FileInfo file) {
        textfile agefile;
        String infile = info.infolder + "/dat/" + file.filename;
        String outfile = info.outfolder + "/dat/" + info.g.getNewAgename(file) + ".age";
        if (file.agename.toLowerCase().equals("personal")) {
            m.warn("Relto may corrupt your savegame, be sure to back up your /sav folder!");
        }
        byte[] decryptedData = UruCrypt.DecryptAny(infile, info.g);
        Integer prefix = info.g.renameinfo.prefices.get(file.agename);
        if (prefix != null) {
            agefile = textfile.createFromBytes(decryptedData);
            agefile.setVariable("SequencePrefix", Integer.toString(prefix));
            decryptedData = agefile.saveToByteArray();
        }
        agefile = textfile.createFromBytes(decryptedData);
        boolean changedpagenames = false;
        for (textfile.textline line : agefile.getLines()) {
            String[] pageparts;
            String oldpagename;
            String newpagename;
            String linestr = line.getString();
            String[] varparts = linestr.split("=");
            if (varparts.length <= 1 || !varparts[0].equals("Page") || (newpagename = (String)info.g.renameinfo.pagenames.get2(file.agename, oldpagename = (pageparts = varparts[1].split(","))[0])) == null) continue;
            changedpagenames = true;
            String newlinestr = linestr.replace(oldpagename, newpagename);
            line.setString(newlinestr);
        }
        if (changedpagenames) {
            decryptedData = agefile.saveToByteArray();
        }
        if (info.g.agemodifier != null) {
            agefile = textfile.createFromBytes(decryptedData);
            info.g.agemodifier.ModifyAge(info, file, agefile);
            decryptedData = agefile.saveToByteArray();
        }
        byte[] wdysData = UruCrypt.EncryptWhatdoyousee(decryptedData);
        FileUtils.WriteFile(outfile, wdysData, true, true);
    }

    public static void convertSum(Info info, FileInfo file) {
        byte[] sum1 = sumfile.createEmptySumfile().getByteArray();
        String outfile = info.outfolder + "/dat/" + info.g.getNewAgename(file) + ".sum";
        FileUtils.WriteFile(outfile, sum1, true, true);
    }

    public static void convertFni(Info info, FileInfo file) {
        String infile = info.infolder + "/dat/" + file.filename;
        String outfile = info.outfolder + "/dat/" + info.g.getNewAgename(file) + ".fni";
        byte[] decryptedData = UruCrypt.DecryptAny(infile, info.g);
        if (info.g.fnimodifier != null) {
            textfile fnifile = textfile.createFromBytes(decryptedData);
            info.g.fnimodifier.ModifyFni(info, file, fnifile);
            decryptedData = fnifile.saveToByteArray();
        }
        byte[] wdysData = UruCrypt.EncryptWhatdoyousee(decryptedData);
        FileUtils.WriteFile(outfile, wdysData, true, true);
    }

    public static void convertBik(Info info, FileInfo file) {
        String infile = info.infolder + "/avi/" + file.filename;
        String outfile = info.outfolder + "/avi/" + info.g.renameinfo.simplefilesrename(file.filename);
        FileUtils.CopyFile(infile, outfile, true, true);
    }

    public static void convertCsv(Info info, FileInfo file) {
        String infile = info.infolder + "/dat/" + file.filename;
        String outfile = info.outfolder + "/dat/" + info.g.getNewAgename(file) + ".csv";
        byte[] decryptedData = UruCrypt.DecryptAny(infile, info.g);
        byte[] wdysData = UruCrypt.EncryptWhatdoyousee(decryptedData);
        FileUtils.WriteFile(outfile, wdysData, true, true);
    }

    public static class RenameInfo {
        public HashMap<String, Integer> prefices = new HashMap();
        public HashMap<String, String> agenames = new HashMap();
        public cmap<String, cmap<Integer, Integer>> pagenums = new cmap();
        public cmap<String, cmap<String, String>> pagenames = new cmap();
        public HashMap<String, String> simplefiles = new HashMap();

        public String simplefilesrename(String oldname) {
            String newname = this.simplefiles.get(oldname);
            if (newname == null) {
                newname = oldname;
            }
            return newname;
        }
    }

    public static enum Filetype {
        fni,
        sum,
        prp,
        age,
        csv,
        ogg,
        sdl,
        pak,
        bik;

    }

    public static class FileInfo {
        String agename;
        String filename;
        Filetype type;

        public void guessFiletype() {
            if (this.filename.endsWith(".fni")) {
                this.type = Filetype.fni;
            } else if (this.filename.endsWith(".sum")) {
                this.type = Filetype.sum;
            } else if (this.filename.endsWith(".prp")) {
                this.type = Filetype.prp;
            } else if (this.filename.endsWith(".age")) {
                this.type = Filetype.age;
            } else if (this.filename.endsWith(".csv")) {
                this.type = Filetype.csv;
            } else if (this.filename.endsWith(".ogg")) {
                this.type = Filetype.ogg;
            } else if (this.filename.endsWith(".sdl")) {
                this.type = Filetype.sdl;
            } else if (this.filename.endsWith(".pak")) {
                this.type = Filetype.pak;
            } else if (this.filename.endsWith(".bik")) {
                this.type = Filetype.bik;
            }
        }

        public String toString() {
            return this.filename;
        }

        public void guessAgename() {
            File f = new File(this.filename);
            String name = f.getName();
            int dotpos = name.indexOf(".");
            int undpos = name.indexOf("_");
            int distpos = name.indexOf("_District_");
            if (this.type == Filetype.prp) {
                this.agename = name.substring(0, undpos);
            } else if (this.type == Filetype.fni || this.type == Filetype.sum || this.type == Filetype.age || this.type == Filetype.csv) {
                this.agename = name.substring(0, dotpos);
            }
        }
    }

    public static interface PostConversionModifier {
        public void ModifyPrp(Info var1, FileInfo var2, prpfile var3);
    }

    public static interface FniModifier {
        public void ModifyFni(Info var1, FileInfo var2, textfile var3);
    }

    public static interface AgeModifier {
        public void ModifyAge(Info var1, FileInfo var2, textfile var3);
    }

    public static class Info {
        String infolder;
        String outfolder;
        AllGames.GameInfo g;
    }
}

