/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Locale;
import org.h2.command.Command;
import org.h2.constant.SysProperties;
import org.h2.constraint.Constraint;
import org.h2.constraint.ConstraintCheck;
import org.h2.constraint.ConstraintReferential;
import org.h2.constraint.ConstraintUnique;
import org.h2.engine.Constants;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.FunctionAlias;
import org.h2.engine.Right;
import org.h2.engine.Role;
import org.h2.engine.Session;
import org.h2.engine.Setting;
import org.h2.engine.User;
import org.h2.engine.UserAggregate;
import org.h2.engine.UserDataType;
import org.h2.expression.ValueExpression;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.index.MetaIndex;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.schema.Constant;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObject;
import org.h2.schema.Sequence;
import org.h2.schema.TriggerObject;
import org.h2.store.InDoubtTransaction;
import org.h2.store.PageStore;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableView;
import org.h2.tools.Csv;
import org.h2.util.MathUtils;
import org.h2.util.New;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.CompareMode;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueNull;
import org.h2.value.ValueString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaTable
extends Table {
    public static final long ROW_COUNT_APPROXIMATION = 1000L;
    private static final String CHARACTER_SET_NAME = "Unicode";
    private static final int TABLES = 0;
    private static final int COLUMNS = 1;
    private static final int INDEXES = 2;
    private static final int TABLE_TYPES = 3;
    private static final int TYPE_INFO = 4;
    private static final int CATALOGS = 5;
    private static final int SETTINGS = 6;
    private static final int HELP = 7;
    private static final int SEQUENCES = 8;
    private static final int USERS = 9;
    private static final int ROLES = 10;
    private static final int RIGHTS = 11;
    private static final int FUNCTION_ALIASES = 12;
    private static final int SCHEMATA = 13;
    private static final int TABLE_PRIVILEGES = 14;
    private static final int COLUMN_PRIVILEGES = 15;
    private static final int COLLATIONS = 16;
    private static final int VIEWS = 17;
    private static final int IN_DOUBT = 18;
    private static final int CROSS_REFERENCES = 19;
    private static final int CONSTRAINTS = 20;
    private static final int FUNCTION_COLUMNS = 21;
    private static final int CONSTANTS = 22;
    private static final int DOMAINS = 23;
    private static final int TRIGGERS = 24;
    private static final int SESSIONS = 25;
    private static final int LOCKS = 26;
    private static final int SESSION_STATE = 27;
    private static final int META_TABLE_TYPE_COUNT = 28;
    private final int type;
    private final int indexColumn;
    private MetaIndex metaIndex;

    public MetaTable(Schema schema, int n, int n2) {
        super(schema, n, null, true, true);
        Column[] columnArray;
        this.type = n2;
        String string = null;
        switch (n2) {
            case 0: {
                this.setObjectName("TABLES");
                columnArray = this.createColumns("TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "TABLE_TYPE", "STORAGE_TYPE", "SQL", "REMARKS", "LAST_MODIFICATION BIGINT", "ID INT", "TYPE_NAME");
                string = "TABLE_NAME";
                break;
            }
            case 1: {
                this.setObjectName("COLUMNS");
                columnArray = this.createColumns("TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "COLUMN_NAME", "ORDINAL_POSITION INT", "COLUMN_DEFAULT", "IS_NULLABLE", "DATA_TYPE INT", "CHARACTER_MAXIMUM_LENGTH INT", "CHARACTER_OCTET_LENGTH INT", "NUMERIC_PRECISION INT", "NUMERIC_PRECISION_RADIX INT", "NUMERIC_SCALE INT", "CHARACTER_SET_NAME", "COLLATION_NAME", "TYPE_NAME", "NULLABLE INT", "IS_COMPUTED BIT", "SELECTIVITY INT", "CHECK_CONSTRAINT", "SEQUENCE_NAME", "REMARKS", "SOURCE_DATA_TYPE SMALLINT");
                string = "TABLE_NAME";
                break;
            }
            case 2: {
                this.setObjectName("INDEXES");
                columnArray = this.createColumns("TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "NON_UNIQUE BIT", "INDEX_NAME", "ORDINAL_POSITION SMALLINT", "COLUMN_NAME", "CARDINALITY INT", "PRIMARY_KEY BIT", "INDEX_TYPE_NAME", "IS_GENERATED BIT", "INDEX_TYPE SMALLINT", "ASC_OR_DESC", "PAGES INT", "FILTER_CONDITION", "REMARKS", "SQL", "ID INT", "SORT_TYPE INT", "CONSTRAINT_NAME");
                string = "TABLE_NAME";
                break;
            }
            case 3: {
                this.setObjectName("TABLE_TYPES");
                columnArray = this.createColumns("TYPE");
                break;
            }
            case 4: {
                this.setObjectName("TYPE_INFO");
                columnArray = this.createColumns("TYPE_NAME", "DATA_TYPE INT", "PRECISION INT", "PREFIX", "SUFFIX", "PARAMS", "AUTO_INCREMENT BIT", "MINIMUM_SCALE SMALLINT", "MAXIMUM_SCALE SMALLINT", "RADIX INT", "POS INT", "CASE_SENSITIVE BIT", "NULLABLE SMALLINT", "SEARCHABLE SMALLINT");
                break;
            }
            case 5: {
                this.setObjectName("CATALOGS");
                columnArray = this.createColumns("CATALOG_NAME");
                break;
            }
            case 6: {
                this.setObjectName("SETTINGS");
                columnArray = this.createColumns("NAME", "VALUE");
                break;
            }
            case 7: {
                this.setObjectName("HELP");
                columnArray = this.createColumns("ID INT", "SECTION", "TOPIC", "SYNTAX", "TEXT");
                break;
            }
            case 8: {
                this.setObjectName("SEQUENCES");
                columnArray = this.createColumns("SEQUENCE_CATALOG", "SEQUENCE_SCHEMA", "SEQUENCE_NAME", "CURRENT_VALUE BIGINT", "INCREMENT BIGINT", "IS_GENERATED BIT", "REMARKS", "CACHE BIGINT", "ID INT");
                break;
            }
            case 9: {
                this.setObjectName("USERS");
                columnArray = this.createColumns("NAME", "ADMIN", "REMARKS", "ID INT");
                break;
            }
            case 10: {
                this.setObjectName("ROLES");
                columnArray = this.createColumns("NAME", "REMARKS", "ID INT");
                break;
            }
            case 11: {
                this.setObjectName("RIGHTS");
                columnArray = this.createColumns("GRANTEE", "GRANTEETYPE", "GRANTEDROLE", "RIGHTS", "TABLE_SCHEMA", "TABLE_NAME", "ID INT");
                string = "TABLE_NAME";
                break;
            }
            case 12: {
                this.setObjectName("FUNCTION_ALIASES");
                columnArray = this.createColumns("ALIAS_CATALOG", "ALIAS_SCHEMA", "ALIAS_NAME", "JAVA_CLASS", "JAVA_METHOD", "DATA_TYPE INT", "COLUMN_COUNT INT", "RETURNS_RESULT SMALLINT", "REMARKS", "ID INT", "SOURCE");
                break;
            }
            case 21: {
                this.setObjectName("FUNCTION_COLUMNS");
                columnArray = this.createColumns("ALIAS_CATALOG", "ALIAS_SCHEMA", "ALIAS_NAME", "JAVA_CLASS", "JAVA_METHOD", "COLUMN_COUNT INT", "POS INT", "COLUMN_NAME", "DATA_TYPE INT", "TYPE_NAME", "PRECISION INT", "SCALE SMALLINT", "RADIX SMALLINT", "NULLABLE SMALLINT", "COLUMN_TYPE SMALLINT", "REMARKS", "COLUMN_DEFAULT");
                break;
            }
            case 13: {
                this.setObjectName("SCHEMATA");
                columnArray = this.createColumns("CATALOG_NAME", "SCHEMA_NAME", "SCHEMA_OWNER", "DEFAULT_CHARACTER_SET_NAME", "DEFAULT_COLLATION_NAME", "IS_DEFAULT BIT", "REMARKS", "ID INT");
                break;
            }
            case 14: {
                this.setObjectName("TABLE_PRIVILEGES");
                columnArray = this.createColumns("GRANTOR", "GRANTEE", "TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "PRIVILEGE_TYPE", "IS_GRANTABLE");
                string = "TABLE_NAME";
                break;
            }
            case 15: {
                this.setObjectName("COLUMN_PRIVILEGES");
                columnArray = this.createColumns("GRANTOR", "GRANTEE", "TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "COLUMN_NAME", "PRIVILEGE_TYPE", "IS_GRANTABLE");
                string = "TABLE_NAME";
                break;
            }
            case 16: {
                this.setObjectName("COLLATIONS");
                columnArray = this.createColumns("NAME", "KEY");
                break;
            }
            case 17: {
                this.setObjectName("VIEWS");
                columnArray = this.createColumns("TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "VIEW_DEFINITION", "CHECK_OPTION", "IS_UPDATABLE", "STATUS", "REMARKS", "ID INT");
                string = "TABLE_NAME";
                break;
            }
            case 18: {
                this.setObjectName("IN_DOUBT");
                columnArray = this.createColumns("TRANSACTION", "STATE");
                break;
            }
            case 19: {
                this.setObjectName("CROSS_REFERENCES");
                columnArray = this.createColumns("PKTABLE_CATALOG", "PKTABLE_SCHEMA", "PKTABLE_NAME", "PKCOLUMN_NAME", "FKTABLE_CATALOG", "FKTABLE_SCHEMA", "FKTABLE_NAME", "FKCOLUMN_NAME", "ORDINAL_POSITION SMALLINT", "UPDATE_RULE SMALLINT", "DELETE_RULE SMALLINT", "FK_NAME", "PK_NAME", "DEFERRABILITY SMALLINT");
                string = "PKTABLE_NAME";
                break;
            }
            case 20: {
                this.setObjectName("CONSTRAINTS");
                columnArray = this.createColumns("CONSTRAINT_CATALOG", "CONSTRAINT_SCHEMA", "CONSTRAINT_NAME", "CONSTRAINT_TYPE", "TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "UNIQUE_INDEX_NAME", "CHECK_EXPRESSION", "COLUMN_LIST", "REMARKS", "SQL", "ID INT");
                string = "TABLE_NAME";
                break;
            }
            case 22: {
                this.setObjectName("CONSTANTS");
                columnArray = this.createColumns("CONSTANT_CATALOG", "CONSTANT_SCHEMA", "CONSTANT_NAME", "DATA_TYPE INT", "REMARKS", "SQL", "ID INT");
                break;
            }
            case 23: {
                this.setObjectName("DOMAINS");
                columnArray = this.createColumns("DOMAIN_CATALOG", "DOMAIN_SCHEMA", "DOMAIN_NAME", "COLUMN_DEFAULT", "IS_NULLABLE", "DATA_TYPE INT", "PRECISION INT", "SCALE INT", "TYPE_NAME", "SELECTIVITY INT", "CHECK_CONSTRAINT", "REMARKS", "SQL", "ID INT");
                break;
            }
            case 24: {
                this.setObjectName("TRIGGERS");
                columnArray = this.createColumns("TRIGGER_CATALOG", "TRIGGER_SCHEMA", "TRIGGER_NAME", "TRIGGER_TYPE", "TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "BEFORE BIT", "JAVA_CLASS", "QUEUE_SIZE INT", "NO_WAIT BIT", "REMARKS", "SQL", "ID INT");
                break;
            }
            case 25: {
                this.setObjectName("SESSIONS");
                columnArray = this.createColumns("ID INT", "USER_NAME", "SESSION_START", "STATEMENT", "STATEMENT_START");
                break;
            }
            case 26: {
                this.setObjectName("LOCKS");
                columnArray = this.createColumns("TABLE_SCHEMA", "TABLE_NAME", "SESSION_ID INT", "LOCK_TYPE");
                break;
            }
            case 27: {
                this.setObjectName("SESSION_STATE");
                columnArray = this.createColumns("KEY", "SQL");
                break;
            }
            default: {
                throw DbException.throwInternalError("type=" + n2);
            }
        }
        this.setColumns(columnArray);
        if (string == null) {
            this.indexColumn = -1;
        } else {
            this.indexColumn = this.getColumn(string).getColumnId();
            IndexColumn[] indexColumnArray = IndexColumn.wrap(new Column[]{columnArray[this.indexColumn]});
            this.metaIndex = new MetaIndex(this, indexColumnArray, false);
        }
    }

    private Column[] createColumns(String ... stringArray) {
        Column[] columnArray = new Column[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            int n;
            String string2 = stringArray[i];
            int n2 = string2.indexOf(32);
            if (n2 < 0) {
                n = 13;
                string = string2;
            } else {
                n = DataType.getTypeByName((String)string2.substring((int)(n2 + 1))).type;
                string = string2.substring(0, n2);
            }
            columnArray[i] = new Column(string, n);
        }
        return columnArray;
    }

    @Override
    public String getDropSQL() {
        return null;
    }

    @Override
    public String getCreateSQL() {
        return null;
    }

    @Override
    public Index addIndex(Session session, String string, int n, IndexColumn[] indexColumnArray, IndexType indexType, boolean bl, String string2) {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public void lock(Session session, boolean bl, boolean bl2) {
    }

    @Override
    public boolean isLockedExclusively() {
        return false;
    }

    private String identifier(String string) {
        if (this.database.getMode().lowerCaseIdentifiers) {
            string = string == null ? null : StringUtils.toLowerEnglish(string);
        }
        return string;
    }

    private ArrayList<Table> getAllTables(Session session) {
        ArrayList<Table> arrayList = this.database.getAllTablesAndViews(true);
        ArrayList<Table> arrayList2 = session.getLocalTempTables();
        arrayList.addAll(arrayList2);
        return arrayList;
    }

    private boolean checkIndex(Session session, String string, Value value, Value value2) {
        if (string == null || value == null && value2 == null) {
            return true;
        }
        Database database = session.getDatabase();
        ValueString valueString = ValueString.get(string);
        if (value != null && database.compare(valueString, value) < 0) {
            return false;
        }
        return value2 == null || database.compare(valueString, value2) <= 0;
    }

    private String replaceNullWithEmpty(String string) {
        return string == null ? "" : string;
    }

    /*
     * WARNING - void declaration
     */
    public ArrayList<Row> generateRows(Session session, SearchRow searchRow, SearchRow searchRow2) {
        Value value = null;
        Value value2 = null;
        if (this.indexColumn >= 0) {
            if (searchRow != null) {
                value = searchRow.getValue(this.indexColumn);
            }
            if (searchRow2 != null) {
                value2 = searchRow2.getValue(this.indexColumn);
            }
        }
        ArrayList<Row> arrayList = New.arrayList();
        String string = this.identifier(this.database.getShortName());
        switch (this.type) {
            case 0: {
                for (Table table : this.getAllTables(session)) {
                    String string8 = this.identifier(table.getName());
                    if (!this.checkIndex(session, string8, value, value2) || table.isHidden()) continue;
                    String string2 = table.isTemporary() ? (table.isGlobalTemporary() ? "GLOBAL TEMPORARY" : "LOCAL TEMPORARY") : (table.isPersistIndexes() ? "CACHED" : "MEMORY");
                    this.add(arrayList, string, this.identifier(table.getSchema().getName()), string8, table.getTableType(), string2, table.getCreateSQL(), this.replaceNullWithEmpty(table.getComment()), "" + table.getMaxDataModificationId(), "" + table.getId(), null);
                }
                break;
            }
            case 1: {
                for (Table table : this.getAllTables(session)) {
                    String string3 = this.identifier(table.getName());
                    if (!this.checkIndex(session, string3, value, value2) || table.isHidden()) continue;
                    Column[] resultSet = table.getColumns();
                    String n = this.database.getCompareMode().getName();
                    for (int javaMethod = 0; javaMethod < resultSet.length; ++javaMethod) {
                        Column table2 = resultSet[javaMethod];
                        Sequence sequence = table2.getSequence();
                        this.add(arrayList, string, this.identifier(table.getSchema().getName()), string3, this.identifier(table2.getName()), String.valueOf(javaMethod + 1), table2.getDefaultSQL(), table2.isNullable() ? "YES" : "NO", "" + DataType.convertTypeToSQLType(table2.getType()), "" + table2.getPrecisionAsInt(), "" + table2.getPrecisionAsInt(), "" + table2.getPrecisionAsInt(), "10", "" + table2.getScale(), CHARACTER_SET_NAME, n, this.identifier(DataType.getDataType((int)table2.getType()).name), "" + (table2.isNullable() ? 1 : 0), "" + (table2.getComputed() ? "TRUE" : "FALSE"), "" + table2.getSelectivity(), table2.getCheckConstraintSQL(session, table2.getName()), sequence == null ? null : sequence.getName(), this.replaceNullWithEmpty(table2.getComment()), null);
                    }
                }
                break;
            }
            case 2: {
                for (Table table : this.getAllTables(session)) {
                    String inputStreamReader = this.identifier(table.getName());
                    if (!this.checkIndex(session, inputStreamReader, value, value2) || table.isHidden()) continue;
                    ArrayList<Index> dbObject = table.getIndexes();
                    ArrayList<Constraint> string11 = table.getConstraints();
                    for (int javaMethod = 0; dbObject != null && javaMethod < dbObject.size(); ++javaMethod) {
                        Index table3 = dbObject.get(javaMethod);
                        if (table3.getCreateSQL() == null) continue;
                        String string4 = null;
                        for (int i = 0; string11 != null && i < string11.size(); ++i) {
                            Constraint constraint = string11.get(i);
                            if (!constraint.usesIndex(table3)) continue;
                            if (table3.getIndexType().isPrimaryKey()) {
                                if (!constraint.getConstraintType().equals("PRIMARY KEY")) continue;
                                string4 = constraint.getName();
                                continue;
                            }
                            string4 = constraint.getName();
                        }
                        IndexColumn[] table32 = table3.getIndexColumns();
                        for (int i = 0; i < table32.length; ++i) {
                            IndexColumn indexColumn = table32[i];
                            Column column = indexColumn.column;
                            this.add(arrayList, string, this.identifier(table.getSchema().getName()), inputStreamReader, table3.getIndexType().isUnique() ? "FALSE" : "TRUE", this.identifier(table3.getName()), "" + (i + 1), this.identifier(column.getName()), "0", table3.getIndexType().isPrimaryKey() ? "TRUE" : "FALSE", table3.getIndexType().getSQL(), table3.getIndexType().getBelongsToConstraint() ? "TRUE" : "FALSE", "3", (indexColumn.sortType & 1) != 0 ? "D" : "A", "0", "", this.replaceNullWithEmpty(table3.getComment()), table3.getSQL(), "" + table3.getId(), "" + indexColumn.sortType, string4);
                        }
                    }
                }
                break;
            }
            case 3: {
                this.add(arrayList, "TABLE");
                this.add(arrayList, "TABLE LINK");
                this.add(arrayList, "SYSTEM TABLE");
                this.add(arrayList, "VIEW");
                break;
            }
            case 5: {
                this.add(arrayList, string);
                break;
            }
            case 6: {
                Object object;
                for (Setting stringArray : this.database.getAllSettings()) {
                    String sequence = stringArray.getStringValue();
                    if (sequence == null) {
                        sequence = "" + stringArray.getIntValue();
                    }
                    this.add(arrayList, this.identifier(stringArray.getName()), sequence);
                }
                this.add(arrayList, "info.BUILD_ID", "134");
                this.add(arrayList, "info.VERSION_MAJOR", "1");
                this.add(arrayList, "info.VERSION_MINOR", "2");
                this.add(arrayList, "info.VERSION", "" + Constants.getFullVersion());
                if (session.getUser().isAdmin()) {
                    object = new String[]{"java.runtime.version", "java.vm.name", "java.vendor", "os.name", "os.arch", "os.version", "sun.os.patch.level", "file.separator", "path.separator", "line.separator", "user.country", "user.language", "user.variant", "file.encoding"};
                    for (String string5 : object) {
                        this.add(arrayList, "property." + string5, SysProperties.getStringSetting(string5, ""));
                    }
                }
                this.add(arrayList, "CLUSTER", this.database.getCluster());
                this.add(arrayList, "EXCLUSIVE", this.database.getExclusiveSession() == null ? "FALSE" : "TRUE");
                this.add(arrayList, "MODE", this.database.getMode().getName());
                this.add(arrayList, "MULTI_THREADED", this.database.isMultiThreaded() ? "1" : "0");
                this.add(arrayList, "MVCC", this.database.isMultiVersion() ? "TRUE" : "FALSE");
                this.add(arrayList, "QUERY_TIMEOUT", "" + session.getQueryTimeout());
                this.add(arrayList, "h2.allowBigDecimalExtensions", "" + SysProperties.ALLOW_BIG_DECIMAL_EXTENSIONS);
                this.add(arrayList, "h2.baseDir", "" + SysProperties.getBaseDir());
                this.add(arrayList, "h2.check", "" + SysProperties.CHECK);
                this.add(arrayList, "h2.check2", "" + SysProperties.CHECK2);
                this.add(arrayList, "h2.clientTraceDirectory", SysProperties.CLIENT_TRACE_DIRECTORY);
                this.add(arrayList, "h2.collatorCacheSize", "" + SysProperties.getCollatorCacheSize());
                this.add(arrayList, "h2.defaultMaxMemoryUndo", "" + SysProperties.DEFAULT_MAX_MEMORY_UNDO);
                this.add(arrayList, "h2.lobFilesPerDirectory", "" + SysProperties.LOB_FILES_PER_DIRECTORY);
                this.add(arrayList, "h2.logAllErrors", "" + SysProperties.LOG_ALL_ERRORS);
                this.add(arrayList, "h2.logAllErrorsFile", "" + SysProperties.LOG_ALL_ERRORS_FILE);
                this.add(arrayList, "h2.maxFileRetry", "" + SysProperties.MAX_FILE_RETRY);
                this.add(arrayList, "h2.maxQueryTimeout", "" + SysProperties.getMaxQueryTimeout());
                this.add(arrayList, "h2.lobCloseBetweenReads", "" + SysProperties.lobCloseBetweenReads);
                this.add(arrayList, "h2.objectCache", "" + SysProperties.OBJECT_CACHE);
                this.add(arrayList, "h2.objectCacheSize", "" + SysProperties.OBJECT_CACHE_SIZE);
                this.add(arrayList, "h2.objectCacheMaxPerElementSize", "" + SysProperties.OBJECT_CACHE_MAX_PER_ELEMENT_SIZE);
                this.add(arrayList, "h2.optimizeInList", "" + SysProperties.OPTIMIZE_IN_LIST);
                this.add(arrayList, "h2.optimizeSubqueryCache", "" + SysProperties.OPTIMIZE_SUBQUERY_CACHE);
                this.add(arrayList, "h2.recompileAlways", "" + SysProperties.RECOMPILE_ALWAYS);
                this.add(arrayList, "h2.redoBufferSize", "" + SysProperties.REDO_BUFFER_SIZE);
                this.add(arrayList, "h2.runFinalize", "" + SysProperties.runFinalize);
                this.add(arrayList, "h2.scriptDirectory", SysProperties.getScriptDirectory());
                this.add(arrayList, "h2.serverCachedObjects", "" + SysProperties.SERVER_CACHED_OBJECTS);
                this.add(arrayList, "h2.serverResultSetFetchSize", "" + SysProperties.SERVER_RESULT_SET_FETCH_SIZE);
                this.add(arrayList, "h2.sortNullsHigh", "" + SysProperties.SORT_NULLS_HIGH);
                if (!this.database.isPersistent()) break;
                object = this.database.getPageStore();
                this.add(arrayList, "info.FILE_WRITE_TOTAL", "" + ((PageStore)object).getWriteCountTotal());
                this.add(arrayList, "info.FILE_WRITE", "" + ((PageStore)object).getWriteCount());
                this.add(arrayList, "info.FILE_READ", "" + ((PageStore)object).getReadCount());
                this.add(arrayList, "info.CACHE_MAX_SIZE", "" + ((PageStore)object).getCache().getMaxSize());
                this.add(arrayList, "info.CACHE_SIZE", "" + ((PageStore)object).getCache().getSize());
                break;
            }
            case 4: {
                for (DataType byArray : DataType.getTypes()) {
                    if (byArray.hidden || byArray.sqlType == 0) continue;
                    this.add(arrayList, byArray.name, String.valueOf(byArray.sqlType), String.valueOf(MathUtils.convertLongToInt(byArray.maxPrecision)), byArray.prefix, byArray.suffix, byArray.params, String.valueOf(byArray.autoIncrement), String.valueOf(byArray.minScale), String.valueOf(byArray.maxScale), byArray.decimal ? "10" : null, String.valueOf(byArray.sqlTypePos), String.valueOf(byArray.caseSensitive), "1", "3");
                }
                break;
            }
            case 7: {
                String string10 = "/org/h2/res/help.csv";
                try {
                    byte[] exception = Utils.getResource(string10);
                    InputStreamReader inputStreamReader = new InputStreamReader(new ByteArrayInputStream(exception));
                    ResultSet resultSet = Csv.getInstance().read(inputStreamReader, null);
                    int n = 0;
                    while (resultSet.next()) {
                        this.add(arrayList, String.valueOf(n), resultSet.getString(1).trim(), resultSet.getString(2).trim(), resultSet.getString(3).trim(), resultSet.getString(4).trim());
                        ++n;
                    }
                    break;
                }
                catch (Exception schemaObject) {
                    throw DbException.convert(schemaObject);
                }
            }
            case 8: {
                for (SchemaObject user : this.database.getAllSchemaObjects(3)) {
                    Sequence n = (Sequence)user;
                    this.add(arrayList, string, this.identifier(n.getSchema().getName()), this.identifier(n.getName()), String.valueOf(n.getCurrentValue()), String.valueOf(n.getIncrement()), n.getBelongsToTable() ? "TRUE" : "FALSE", this.replaceNullWithEmpty(n.getComment()), String.valueOf(n.getCacheSize()), "" + n.getId());
                }
                break;
            }
            case 9: {
                for (User role : this.database.getAllUsers()) {
                    this.add(arrayList, this.identifier(role.getName()), String.valueOf(role.isAdmin()), this.replaceNullWithEmpty(role.getComment()), "" + role.getId());
                }
                break;
            }
            case 10: {
                for (Role right : this.database.getAllRoles()) {
                    this.add(arrayList, this.identifier(right.getName()), this.replaceNullWithEmpty(right.getComment()), "" + right.getId());
                }
                break;
            }
            case 11: {
                for (Right dbObjectBase : this.database.getAllRights()) {
                    String dbObject;
                    Role role = dbObjectBase.getGrantedRole();
                    DbObject string15 = dbObjectBase.getGrantee();
                    String string6 = dbObject = string15.getType() == 2 ? "USER" : "ROLE";
                    if (role == null) {
                        Table n = dbObjectBase.getGrantedTable();
                        String string7 = this.identifier(n.getName());
                        if (!this.checkIndex(session, string7, value, value2)) continue;
                        this.add(arrayList, this.identifier(string15.getName()), dbObject, "", dbObjectBase.getRights(), this.identifier(n.getSchema().getName()), this.identifier(n.getName()), "" + dbObjectBase.getId());
                        continue;
                    }
                    this.add(arrayList, this.identifier(string15.getName()), dbObject, this.identifier(role.getName()), "", "", "", "" + dbObjectBase.getId());
                }
                break;
            }
            case 12: {
                for (FunctionAlias functionAlias : this.database.getAllFunctionAliases()) {
                    for (FunctionAlias.JavaMethod indexColumnArray2 : functionAlias.getJavaMethods()) {
                        int n = indexColumnArray2.getDataType() == 0 ? 1 : 2;
                        this.add(arrayList, string, "PUBLIC", this.identifier(functionAlias.getName()), functionAlias.getJavaClassName(), functionAlias.getJavaMethodName(), "" + DataType.convertTypeToSQLType(indexColumnArray2.getDataType()), "" + indexColumnArray2.getColumnClasses().length, "" + n, this.replaceNullWithEmpty(functionAlias.getComment()), "" + functionAlias.getId(), functionAlias.getSource());
                    }
                }
                for (UserAggregate right : this.database.getAllAggregates()) {
                    int table = 2;
                    this.add(arrayList, string, "PUBLIC", this.identifier(right.getName()), right.getJavaClassName(), "", "" + DataType.convertTypeToSQLType(0), "1", "" + table, this.replaceNullWithEmpty(right.getComment()), "" + right.getId());
                }
                break;
            }
            case 21: {
                for (FunctionAlias right : this.database.getAllFunctionAliases()) {
                    for (FunctionAlias.JavaMethod indexColumnArray : right.getJavaMethods()) {
                        Class<?>[] classArray = indexColumnArray.getColumnClasses();
                        for (int i = 0; i < classArray.length; ++i) {
                            Class<?> clazz = classArray[i];
                            int n = DataType.getTypeFromClass(clazz);
                            DataType dataType = DataType.getDataType(n);
                            int n2 = clazz.isPrimitive() ? 0 : 1;
                            this.add(arrayList, string, "PUBLIC", this.identifier(right.getName()), right.getJavaClassName(), right.getJavaMethodName(), "" + indexColumnArray.getParameterCount(), "" + i, "P" + (i + 1), "" + DataType.convertTypeToSQLType(dataType.type), dataType.name, "" + dataType.defaultPrecision, "" + dataType.defaultScale, "10", "" + n2, "1", "", null);
                        }
                    }
                }
                break;
            }
            case 13: {
                String string14 = this.database.getCompareMode().getName();
                for (Schema schema : this.database.getAllSchemas()) {
                    this.add(arrayList, string, this.identifier(schema.getName()), this.identifier(schema.getOwner().getName()), CHARACTER_SET_NAME, string14, "PUBLIC".equals(schema.getName()) ? "TRUE" : "FALSE", this.replaceNullWithEmpty(schema.getComment()), "" + schema.getId());
                }
                break;
            }
            case 14: {
                for (Right table : this.database.getAllRights()) {
                    String tableView;
                    Table string17 = table.getGrantedTable();
                    if (string17 == null || string17.isHidden() || !this.checkIndex(session, tableView = this.identifier(string17.getName()), value, value2)) continue;
                    this.addPrivileges(arrayList, table.getGrantee(), string, string17, null, table.getRightMask());
                }
                break;
            }
            case 15: {
                for (Right right : this.database.getAllRights()) {
                    String constraintReferential;
                    Table inDoubtTransaction = right.getGrantedTable();
                    if (inDoubtTransaction == null || inDoubtTransaction.isHidden() || !this.checkIndex(session, constraintReferential = this.identifier(inDoubtTransaction.getName()), value, value2)) continue;
                    DbObject session2 = right.getGrantee();
                    int command = right.getRightMask();
                    for (Column column : inDoubtTransaction.getColumns()) {
                        this.addPrivileges(arrayList, session2, string, inDoubtTransaction, column.getName(), command);
                    }
                }
                break;
            }
            case 16: {
                for (Locale string20 : Collator.getAvailableLocales()) {
                    this.add(arrayList, CompareMode.getName(string20), string20.toString());
                }
                break;
            }
            case 17: {
                for (Table schemaObject : this.getAllTables(session)) {
                    String constraint;
                    if (!schemaObject.getTableType().equals("VIEW") || !this.checkIndex(session, constraint = this.identifier(schemaObject.getName()), value, value2)) continue;
                    TableView valueExpression = (TableView)schemaObject;
                    this.add(arrayList, string, this.identifier(schemaObject.getSchema().getName()), constraint, schemaObject.getCreateSQL(), "NONE", "NO", valueExpression.isInvalid() ? "INVALID" : "VALID", this.replaceNullWithEmpty(valueExpression.getComment()), "" + valueExpression.getId());
                }
                break;
            }
            case 18: {
                ArrayList<InDoubtTransaction> arrayList4 = this.database.getInDoubtTransactions();
                if (arrayList4 == null) break;
                for (InDoubtTransaction constant : arrayList4) {
                    this.add(arrayList, constant.getTransaction(), constant.getState());
                }
                break;
            }
            case 19: {
                for (SchemaObject userDataType : this.database.getAllSchemaObjects(5)) {
                    Constraint column = (Constraint)userDataType;
                    if (!column.getConstraintType().equals("REFERENTIAL")) continue;
                    ConstraintReferential table = (ConstraintReferential)column;
                    IndexColumn[] session3 = table.getColumns();
                    IndexColumn[] indexColumnArray = table.getRefColumns();
                    Table table4 = table.getTable();
                    Table table5 = table.getRefTable();
                    String string8 = this.identifier(table5.getName());
                    if (!this.checkIndex(session, string8, value, value2)) continue;
                    int n = this.getRefAction(table.getUpdateAction());
                    int n3 = this.getRefAction(table.getDeleteAction());
                    for (int i = 0; i < session3.length; ++i) {
                        this.add(arrayList, string, this.identifier(table5.getSchema().getName()), this.identifier(table5.getName()), this.identifier(indexColumnArray[i].column.getName()), string, this.identifier(table4.getSchema().getName()), this.identifier(table4.getName()), this.identifier(session3[i].column.getName()), String.valueOf(i + 1), String.valueOf(n), String.valueOf(n3), this.identifier(table.getName()), null, "7");
                    }
                }
                break;
            }
            case 20: {
                for (SchemaObject schemaObject : this.database.getAllSchemaObjects(5)) {
                    void object;
                    String string9;
                    Constraint triggerObject = (Constraint)schemaObject;
                    String string10 = triggerObject.getConstraintType();
                    String value3 = null;
                    Object var13_135 = null;
                    Table table = triggerObject.getTable();
                    if (table.isHidden()) continue;
                    Index index = triggerObject.getUniqueIndex();
                    String string11 = null;
                    if (index != null) {
                        string11 = index.getName();
                    }
                    if (!this.checkIndex(session, string9 = this.identifier(table.getName()), value, value2)) continue;
                    if (string10.equals("CHECK")) {
                        value3 = ((ConstraintCheck)triggerObject).getExpression().getSQL();
                    } else if (string10.equals("UNIQUE") || string10.equals("PRIMARY KEY")) {
                        IndexColumn[] indexColumnArray = ((ConstraintUnique)triggerObject).getColumns();
                    } else if (string10.equals("REFERENTIAL")) {
                        IndexColumn[] indexColumnArray = ((ConstraintReferential)triggerObject).getColumns();
                    }
                    String string12 = null;
                    if (object != null) {
                        StatementBuilder statementBuilder = new StatementBuilder();
                        for (void var23_181 : object) {
                            statementBuilder.appendExceptFirst(",");
                            statementBuilder.append(var23_181.column.getName());
                        }
                        string12 = statementBuilder.toString();
                    }
                    this.add(arrayList, string, this.identifier(triggerObject.getSchema().getName()), this.identifier(triggerObject.getName()), string10, string, this.identifier(table.getSchema().getName()), string9, string11, value3, string12, this.replaceNullWithEmpty(triggerObject.getComment()), triggerObject.getCreateSQL(), "" + triggerObject.getId());
                }
                break;
            }
            case 22: {
                for (SchemaObject schemaObject : this.database.getAllSchemaObjects(11)) {
                    Constant constant = (Constant)schemaObject;
                    ValueExpression valueExpression = constant.getValue();
                    this.add(arrayList, string, this.identifier(constant.getSchema().getName()), this.identifier(constant.getName()), "" + DataType.convertTypeToSQLType(valueExpression.getType()), this.replaceNullWithEmpty(constant.getComment()), valueExpression.getSQL(), "" + constant.getId());
                }
                break;
            }
            case 23: {
                for (UserDataType userDataType : this.database.getAllUserDataTypes()) {
                    Column column = userDataType.getColumn();
                    this.add(arrayList, string, "PUBLIC", this.identifier(userDataType.getName()), column.getDefaultSQL(), column.isNullable() ? "YES" : "NO", "" + column.getDataType().sqlType, "" + column.getPrecisionAsInt(), "" + column.getScale(), column.getDataType().name, "" + column.getSelectivity(), "" + column.getCheckConstraintSQL(session, "VALUE"), this.replaceNullWithEmpty(userDataType.getComment()), "" + userDataType.getCreateSQL(), "" + userDataType.getId());
                }
                break;
            }
            case 24: {
                for (SchemaObject schemaObject : this.database.getAllSchemaObjects(4)) {
                    TriggerObject triggerObject = (TriggerObject)schemaObject;
                    Table string25 = triggerObject.getTable();
                    this.add(arrayList, string, this.identifier(triggerObject.getSchema().getName()), this.identifier(triggerObject.getName()), triggerObject.getTypeNameList(), string, this.identifier(string25.getSchema().getName()), this.identifier(string25.getName()), "" + triggerObject.isBefore(), triggerObject.getTriggerClassName(), "" + triggerObject.getQueueSize(), "" + triggerObject.isNoWait(), this.replaceNullWithEmpty(triggerObject.getComment()), triggerObject.getCreateSQL(), "" + triggerObject.getId());
                }
                break;
            }
            case 25: {
                boolean bl = session.getUser().isAdmin();
                for (Session session2 : this.database.getSessions(false)) {
                    if (!bl && session2 != session) continue;
                    Command command = session2.getCurrentCommand();
                    this.add(arrayList, "" + session2.getId(), session2.getUser().getName(), new Timestamp(session2.getSessionStart()).toString(), command == null ? null : command.toString(), new Timestamp(session2.getCurrentCommandStart()).toString());
                }
                break;
            }
            case 26: {
                boolean bl = session.getUser().isAdmin();
                for (Session session3 : this.database.getSessions(false)) {
                    if (!bl && session3 != session) continue;
                    for (Table table : session3.getLocks()) {
                        this.add(arrayList, table.getSchema().getName(), table.getName(), "" + session3.getId(), table.isLockedExclusivelyBy(session3) ? "WRITE" : "READ");
                    }
                }
                break;
            }
            case 27: {
                String string13;
                for (String string14 : session.getVariableNames()) {
                    Value value3 = session.getVariable(string14);
                    this.add(arrayList, "@" + string14, "SET @" + string14 + " " + value3.getSQL());
                }
                for (Table table : session.getLocalTempTables()) {
                    this.add(arrayList, "TABLE " + table.getName(), table.getCreateSQL());
                }
                String[] stringArray = session.getSchemaSearchPath();
                if (stringArray != null && stringArray.length > 0) {
                    StatementBuilder statementBuilder = new StatementBuilder("SET SCHEMA_SEARCH_PATH ");
                    for (Object object : stringArray) {
                        statementBuilder.appendExceptFirst(", ");
                        statementBuilder.append(StringUtils.quoteIdentifier((String)object));
                    }
                    this.add(arrayList, "SCHEMA_SEARCH_PATH", statementBuilder.toString());
                }
                if ((string13 = session.getCurrentSchemaName()) == null) break;
                this.add(arrayList, "SCHEMA", "SET SCHEMA " + StringUtils.quoteIdentifier(string13));
                break;
            }
            default: {
                DbException.throwInternalError("type=" + this.type);
            }
        }
        return arrayList;
    }

    private int getRefAction(int n) {
        switch (n) {
            case 1: {
                return 0;
            }
            case 0: {
                return 1;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 2;
            }
        }
        throw DbException.throwInternalError("action=" + n);
    }

    @Override
    public void removeRow(Session session, Row row) {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public void addRow(Session session, Row row) {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public void unlock(Session session) {
    }

    private void addPrivileges(ArrayList<Row> arrayList, DbObject dbObject, String string, Table table, String string2, int n) {
        if ((n & 1) != 0) {
            this.addPrivilege(arrayList, dbObject, string, table, string2, "SELECT");
        }
        if ((n & 4) != 0) {
            this.addPrivilege(arrayList, dbObject, string, table, string2, "INSERT");
        }
        if ((n & 8) != 0) {
            this.addPrivilege(arrayList, dbObject, string, table, string2, "UPDATE");
        }
        if ((n & 2) != 0) {
            this.addPrivilege(arrayList, dbObject, string, table, string2, "DELETE");
        }
    }

    private void addPrivilege(ArrayList<Row> arrayList, DbObject dbObject, String string, Table table, String string2, String string3) {
        User user;
        String string4 = "NO";
        if (dbObject.getType() == 2 && (user = (User)dbObject).isAdmin()) {
            string4 = "YES";
        }
        if (string2 == null) {
            this.add(arrayList, null, this.identifier(dbObject.getName()), string, this.identifier(table.getSchema().getName()), this.identifier(table.getName()), string3, string4);
        } else {
            this.add(arrayList, null, this.identifier(dbObject.getName()), string, this.identifier(table.getSchema().getName()), this.identifier(table.getName()), this.identifier(string2), string3, string4);
        }
    }

    private void add(ArrayList<Row> arrayList, String ... stringArray) {
        Value[] valueArray = new Value[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            Value value = string == null ? ValueNull.INSTANCE : ValueString.get(string);
            Column column = this.columns[i];
            value = column.convert(value);
            valueArray[i] = value;
        }
        Row row = new Row(valueArray, 1);
        row.setKey(arrayList.size());
        arrayList.add(row);
    }

    @Override
    public void checkRename() {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public void checkSupportAlter() {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public void truncate(Session session) {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public long getRowCount(Session session) {
        throw DbException.throwInternalError();
    }

    @Override
    public boolean canGetRowCount() {
        return false;
    }

    @Override
    public boolean canDrop() {
        return false;
    }

    @Override
    public String getTableType() {
        return "SYSTEM TABLE";
    }

    @Override
    public Index getScanIndex(Session session) {
        return new MetaIndex(this, IndexColumn.wrap(this.columns), true);
    }

    @Override
    public ArrayList<Index> getIndexes() {
        if (this.metaIndex == null) {
            return null;
        }
        ArrayList<Index> arrayList = New.arrayList();
        arrayList.add(new MetaIndex(this, IndexColumn.wrap(this.columns), true));
        arrayList.add(this.metaIndex);
        return arrayList;
    }

    @Override
    public long getMaxDataModificationId() {
        return this.database.getModificationDataId();
    }

    @Override
    public Index getUniqueIndex() {
        return null;
    }

    public static int getMetaTableTypeCount() {
        return 28;
    }

    @Override
    public long getRowCountApproximation() {
        return 1000L;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }
}

