/*
 * Decompiled with CFR 0.152.
 */
package mystProxy;

import java.io.File;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import mystProxy.allPackages;
import mystProxy.fileHandler;
import mystProxy.packageInfo;
import mystProxy.proxySettings;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.bio.SocketConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import shared.State.AllStates;
import shared.m;

public class mystProxy {
    static Server server;

    public static void startServer(String basefolder2, String portstring) {
        if (server != null) {
            m.err("Server is already started.");
            return;
        }
        proxySettings.basefolder = basefolder2;
        int port = 0;
        try {
            port = Integer.parseInt(portstring);
        }
        catch (Exception e2) {
            m.err("Invalid port.");
            return;
        }
        mystProxy.loadAllInfo();
        server = new Server();
        SocketConnector connector = new SocketConnector();
        connector.setPort(port);
        server.setConnectors(new Connector[]{connector});
        mystHandler handler = new mystHandler();
        server.setHandler(handler);
        try {
            m.msg("Starting proxy server.");
            server.start();
        }
        catch (Exception e3) {
            m.err("Proxy server crashed.");
        }
        proxySettings.logFilesRead = AllStates.getStateAsBoolean("proxyLogReads");
    }

    public static void stopServer() {
        if (server == null) {
            m.msg("Server is already stopped.");
            return;
        }
        try {
            server.stop();
            server = null;
            m.msg("Server has been stopped.");
        }
        catch (Exception e2) {
            m.err("Unable to stop server.");
        }
    }

    public static void loadAllInfo() {
        File[] basefiles;
        proxySettings.packages = new allPackages();
        File base = new File(proxySettings.basefolder);
        for (File file : basefiles = base.listFiles()) {
            packageInfo curpackage;
            if (file.isDirectory()) {
                curpackage = new packageInfo(file, false);
                proxySettings.packages.packages.add(curpackage);
                continue;
            }
            if (!file.getName().toLowerCase().endsWith(".zip")) continue;
            curpackage = new packageInfo(file, true);
            proxySettings.packages.packages.add(curpackage);
        }
    }

    public static class mystHandler
    extends AbstractHandler {
        public void handle(String target, Request req2, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            this.handle(target, request, response, 0);
        }

        public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
            fileHandler.handle(null, target, request, response, dispatch);
        }
    }
}

