/*
 * Decompiled with CFR 0.152.
 */
package moulserver;

import java.net.Inet4Address;
import java.net.InetAddress;
import jonelo.jacksum.adapt.gnu.crypto.hash.Sha0;
import moulserver.AbstractManager;
import moulserver.AgesInfo;
import moulserver.AuthServer;
import moulserver.Comm;
import moulserver.ConnectionState;
import moulserver.Database;
import moulserver.FileServer;
import moulserver.GameMainServer;
import moulserver.GateServer;
import moulserver.HttpServer;
import moulserver.NetServer;
import moulserver.Server;
import moulserver.ServerType;
import moulserver.Settings;
import moulserver.SuperManager;
import moulserver.VaultListeners;
import shared.FileUtils;
import shared.b;
import shared.uncaughtexception;

public class Manager
extends AbstractManager {
    static final int msToSleep = 4;
    static Manager manager;
    public Settings settings;
    public Database database;
    public int address;
    public AgesInfo agesinfo;
    public Comm comm;
    private NetServer netserver;
    private HttpServer httpserver;
    private GateServer gateserver;
    private FileServer fileserver;
    public AuthServer authserver;
    public GameMainServer gamemainserver;
    public VaultListeners vaultlistener;

    public static void test(String input) {
        try {
            String username = "name@example.com";
            String password = "password";
            int serverchallenge = 0;
            int clientchallenge = 1656653401;
            Sha0 sha = new Sha0();
            byte[] pwbs = b.Utf16ToBytes(password);
            byte[] unbs = b.Utf16ToBytes(username.toLowerCase());
            byte[] both = new byte[pwbs.length + unbs.length];
            b.CopyBytes(pwbs, both, 0);
            b.CopyBytes(unbs, both, pwbs.length);
            both[pwbs.length - 1] = 0;
            both[pwbs.length - 2] = 0;
            both[both.length - 1] = 0;
            both[both.length - 2] = 0;
            Sha0 sha0 = new Sha0();
            sha0.update(both, 0, both.length);
            byte[] UnAndPwHash = sha0.digest();
            byte[] all = new byte[8 + UnAndPwHash.length];
            b.loadInt32IntoBytes(clientchallenge, all, 0);
            b.loadInt32IntoBytes(serverchallenge, all, 4);
            b.CopyBytes(UnAndPwHash, all, 8);
            sha0.update(all, 0, all.length);
            byte[] hash = sha0.digest();
            return;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return;
        }
    }

    public static void StartServers(String mainpassword, String domainname, String datapath) {
        Settings settings = new Settings();
        settings.setDomainName(domainname);
        settings.setMainPassword(mainpassword);
        settings.setDatapath(datapath);
        Manager mgr = new Manager();
        mgr.StartServers(settings);
    }

    public void StartServers(Settings stngs) {
        manager = this;
        this.settings = stngs;
        SuperManager.SetAgeInfoFolder(this.settings.getPathToAgeFiles(), this.settings.getPathToSdlFiles());
        this.comm = new Comm();
        this.vaultlistener = new VaultListeners();
        try {
            InetAddress addr = Inet4Address.getByName(this.settings.getDomainName());
            Inet4Address addr4 = (Inet4Address)addr;
            byte[] addrbs = addr4.getAddress();
            int bigEndianAddress = b.BytesToInt32(addrbs, 0);
            this.address = b.reverseEndianness(bigEndianAddress);
        }
        catch (Exception e2) {
            throw new uncaughtexception("unabled to get address from server name for some reason: " + this.settings.getDomainName());
        }
        this.agesinfo = new AgesInfo(this.settings.getPathToAgeFiles(), this.settings.getPathToSdlFiles());
        this.database = new Database();
        this.database.initialise(this.settings.getDatabasefile());
        this.gateserver = new GateServer(this);
        this.gateserver.start();
        this.fileserver = new FileServer(this);
        this.fileserver.start();
        this.authserver = new AuthServer(this);
        this.authserver.start();
        this.gamemainserver = new GameMainServer(this);
        this.gamemainserver.start();
        this.netserver = new NetServer(this);
        this.netserver.start();
        this.httpserver = new HttpServer(this);
        this.httpserver.start();
    }

    public void HandleMessage(ServerType servertype, Server.ServerMsg msg, ConnectionState cs) {
        switch (servertype) {
            case GateServer: {
                this.gateserver.items.add(Comm.CommItem.HandleMessage(msg, cs));
                break;
            }
            case FileServer: {
                this.fileserver.items.add(Comm.CommItem.HandleMessage(msg, cs));
                break;
            }
            case AuthServer: {
                this.authserver.items.add(Comm.CommItem.HandleMessage(msg, cs));
                break;
            }
            case GameServer: {
                this.gamemainserver.HandleMessageDirect(Comm.CommItem.HandleMessage(msg, cs));
                break;
            }
            default: {
                throw new uncaughtexception("Unhandled state");
            }
        }
    }

    public void removeConnectionState(ConnectionState cs) {
        this.netserver.removeConnectionState(cs);
    }

    public AgesInfo getagesinfo() {
        return this.agesinfo;
    }

    public static void StartClient(Settings settings) {
    }

    public static void dumppacket(byte[] packet) {
        String curname;
        String folder = "H:/DontBackup/prps/moulserver/packets/";
        int i = 0;
        while (FileUtils.Exists(curname = folder + "/packet" + Integer.toString(i) + ".hex")) {
            ++i;
        }
        FileUtils.WriteFile(curname, packet);
    }

    public static void ensurePlayerIsOnline(int playerIdx) {
    }
}

