/*
 * Decompiled with CFR 0.152.
 */
package moulserver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import moulserver.AuthServer;
import moulserver.Comm;
import moulserver.ConnectionState;
import moulserver.GameMainServer;
import moulserver.Manager;
import moulserver.Node;
import moulserver.RawNode;
import moulserver.SdlBinary;
import parsers.ageparser;
import prpobjects.Guid;
import prpobjects.Location;
import prpobjects.PrpTaggedObject;
import prpobjects.Typeid;
import prpobjects.Uruobjectdesc;
import prpobjects.plAvatarInputStateMsg;
import prpobjects.plLoadCloneMsg;
import prpobjects.plNetMsgGameMessage;
import prpobjects.plNetMsgGameStateRequest;
import prpobjects.plNetMsgGroupOwner;
import prpobjects.plNetMsgInitialAgeStateSent;
import prpobjects.plNetMsgLoadClone;
import prpobjects.plNetMsgMembersList;
import prpobjects.plNetMsgMembersListReq;
import prpobjects.plNetMsgPagingRoom;
import prpobjects.plNetMsgPlayerPage;
import prpobjects.plNetMsgRelevanceRegions;
import prpobjects.plNetMsgRoomsList;
import prpobjects.plNetMsgSDLState;
import prpobjects.plNetMsgSDLStateBCast;
import prpobjects.plNetMsgTestAndSet;
import prpobjects.plServerReplyMsg;
import shared.ByteArrayBytestream;
import shared.Concurrent;
import shared.DateTimeUtils;
import shared.Format;
import shared.IBytestream;
import shared.m;
import shared.nested;
import uru.Bytedeque;

public class GameServer
extends Thread {
    public static final int minShutdown = 600;
    Manager manager;
    public int gameServerNumber;
    String ageFilename;
    Guid ageInstanceGuid;
    ageparser.Agefile ageinfo;
    AtomicInteger timeToShutdown;
    ConnectionState dummycs = ConnectionState.dummy();
    Queue<Comm.CommItem> items = Concurrent.getConcurrentQueue();
    ArrayList<plLoadCloneMsg> clones = new ArrayList();
    ArrayList<SdlState> sdlstates = new ArrayList();
    ArrayList<ConnectionState> connections = new ArrayList();
    IdentityHashMap<ConnectionState, plLoadCloneMsg> connectionToClone = new IdentityHashMap();
    HashMap<Integer, ConnectionState> playeridToConnection = new HashMap();
    ArrayList<Page> pages = new ArrayList();
    int sdlIdx;
    String sdlStatedesc;

    private SdlState findSdlState(Uruobjectdesc desc, SdlBinary sdlbin) {
        for (SdlState sdl : this.sdlstates) {
            if (!sdl.desc.equals(desc) || !sdl.sdlvars.name.toString().equals(sdlbin.name.toString())) continue;
            return sdl;
        }
        return null;
    }

    public plLoadCloneMsg findClone(plLoadCloneMsg msg2) {
        for (plLoadCloneMsg clone : this.clones) {
            if (!clone.cloneKey.equals(msg2.cloneKey)) continue;
            return clone;
        }
        return null;
    }

    private Page findPage(int pagenum) {
        for (Page page : this.pages) {
            if (page.pageinfo.pagenum != pagenum) continue;
            return page;
        }
        return null;
    }

    public GameServer(int number, String filename, Guid guid, Manager manager) {
        this.manager = manager;
        this.gameServerNumber = number;
        this.ageFilename = filename;
        this.ageInstanceGuid = guid;
        this.timeToShutdown = new AtomicInteger(DateTimeUtils.getCurrentTimeInSeconds());
        this.setMinimumShutdownTime(600);
        this.ageinfo = manager.agesinfo.getAge(this.ageFilename);
        for (ageparser.PageInfo pageinfo : this.ageinfo.pages) {
            Page page = new Page();
            page.pageinfo = pageinfo;
            this.pages.add(page);
        }
    }

    public void run() {
        m.msg("Starting GameServer: " + this.ageFilename + ", " + this.ageInstanceGuid.toString());
        Object noderesponse = this.manager.comm.SendAndWait(Comm.CommItem.GetAgeSdl(this.ageInstanceGuid), this.manager.authserver.items);
        Node.SDLNode sdl = (Node.SDLNode)((Comm.CommItem)noderesponse).node.cast();
        this.sdlIdx = sdl.getIdx();
        this.sdlStatedesc = sdl.getStatedescName();
        while (true) {
            Comm.CommItem item;
            if ((item = this.items.poll()) != null) {
                if (item.type == Comm.CommItemType.HandleMessage) {
                    this.HandleMessage(item.msg, item.connstate);
                    continue;
                }
                if (item.type == Comm.CommItemType.NodeChange) {
                    AuthServer.VaultNodeChanged msg = (AuthServer.VaultNodeChanged)item.msg;
                    Object n = Node.getNodeWithIndex(msg.nodeId);
                    if (((Node)n).getType() == 23) {
                        if (item.connstate == this.dummycs) continue;
                        Node.PlayerInfoNode playerinfo = (Node.PlayerInfoNode)n;
                        int linkstatus = playerinfo.getCurrentLinkStatus();
                        m.msg("GameServer: player link status set to: " + Integer.toString(linkstatus));
                        if (!playerinfo.getCurrentAgeFilename().equals("")) continue;
                    }
                    m.throwUncaughtException("unexpected");
                    continue;
                }
                m.throwUncaughtException("unhandled");
                continue;
            }
            try {
                Thread.sleep(4L);
            }
            catch (Exception e2) {
            }
        }
    }

    private void HandleMessage(Object msg, ConnectionState cs) {
        Class<?> klass = msg.getClass();
        if (klass == GameMainServer.JoinAgeRequest.class) {
            m.msg("GameServer JoinAgeRequest");
            GameMainServer.JoinAgeRequest request = (GameMainServer.JoinAgeRequest)msg;
            this.connections.add(cs);
            cs.player = (Node.PlayerNode)Node.getNodeWithIndex(cs.playerId);
            cs.playerInfoIdx = Node.PlayerInfoNode.getFromPlayerId(cs.playerId).getIdx();
            this.playeridToConnection.put(cs.playerId, cs);
            this.manager.comm.registerForNodeChange(cs.playerInfoIdx, this.items);
            GameMainServer.JoinAgeReply reply = new GameMainServer.JoinAgeReply();
            reply.transId = request.transId;
            reply.result = 0;
            GameServer.SendMsg(cs, reply);
            boolean isOwner = true;
            Location pageloc = Location.createWithPrefixPagenumPagetype(0, 0, 4);
            plNetMsgGroupOwner bmsg = plNetMsgGroupOwner.createWithInfo(pageloc, isOwner);
            GameMainServer.PropagateBuffer bmsg2 = GameMainServer.PropagateBuffer.createWithObj(Typeid.plNetMsgGroupOwner, bmsg);
            this.TestMsg(bmsg2);
            GameServer.SendMsg(cs, bmsg2);
        } else if (klass == GameMainServer.PropagateBuffer.class) {
            GameMainServer.PropagateBuffer request = (GameMainServer.PropagateBuffer)msg;
            try {
                PrpTaggedObject obj = request.obj;
                if (obj.type == Typeid.plNetMsgLoadClone) {
                    plNetMsgLoadClone loadclonemsg = (plNetMsgLoadClone)obj.prpobject.object;
                    this.HandlePlNetMsgLoadClone(loadclonemsg, cs);
                } else if (obj.type == Typeid.plNetMsgPlayerPage) {
                    plNetMsgPlayerPage msg2 = (plNetMsgPlayerPage)obj.prpobject.object;
                    this.HandlePlNetMsgPlayerPage(msg2, cs);
                } else if (obj.type == Typeid.plNetMsgTestAndSet) {
                    plNetMsgTestAndSet msg2 = (plNetMsgTestAndSet)obj.prpobject.object;
                    this.HandlePlNetMsgTestAndSet(msg2, cs);
                } else if (obj.type == Typeid.plNetMsgMembersListReq) {
                    plNetMsgMembersListReq msg2 = (plNetMsgMembersListReq)obj.prpobject.object;
                    this.HandlePlNetMsgMembersListReq(msg2, cs);
                } else if (obj.type == Typeid.plNetMsgGameStateRequest) {
                    plNetMsgGameStateRequest msg2 = (plNetMsgGameStateRequest)obj.prpobject.object;
                    this.HandlePlNetMsgGameStateRequest(msg2, cs);
                } else if (obj.type == Typeid.plNetMsgRelevanceRegions) {
                    plNetMsgRelevanceRegions msg2 = (plNetMsgRelevanceRegions)obj.prpobject.object;
                    this.HandlePlNetMsgRelevanceRegions(msg2, cs);
                } else if (obj.type == Typeid.plNetMsgGameMessage) {
                    plNetMsgGameMessage msg2 = (plNetMsgGameMessage)obj.prpobject.object;
                    this.HandlePlNetMsgGameMessage(msg2, cs);
                } else if (obj.type == Typeid.plNetMsgPagingRoom) {
                    plNetMsgPagingRoom msg2 = (plNetMsgPagingRoom)obj.prpobject.object;
                    this.HandlePlNetMsgPagingRoom(msg2, cs);
                } else if (obj.type == Typeid.plNetMsgSDLState) {
                    plNetMsgSDLState msg2 = (plNetMsgSDLState)obj.prpobject.object;
                    this.HandlePlNetMsgSDLState(msg2, cs);
                } else if (obj.type == Typeid.plNetMsgSDLStateBCast) {
                    plNetMsgSDLStateBCast msg2 = (plNetMsgSDLStateBCast)obj.prpobject.object;
                    this.HandlePlNetMsgSDLStateBCast(msg2, cs);
                } else {
                    m.warn("unhandled");
                }
            }
            catch (Exception e2) {
                throw new nested(e2);
            }
            boolean dummy = false;
        } else {
            m.throwUncaughtException("Unhandled GameServer packet: " + klass.getSimpleName());
        }
    }

    private void HandlePlNetMsgSDLStateBCast(plNetMsgSDLStateBCast msg, ConnectionState cs) {
        m.msg("PlNetMsgSDLStateBCast");
        this.saveSDLState(msg.parent);
    }

    private void HandlePlNetMsgSDLState(plNetMsgSDLState msg, ConnectionState cs) {
        m.msg("PlNetMsgSDLState");
        this.saveSDLState(msg);
    }

    private void saveSDLState(plNetMsgSDLState msg) {
        Uruobjectdesc desc = msg.parent.parent.desc;
        SdlBinary sdlbin = msg.getSdlBinary();
        SdlState sdlstate = this.findSdlState(desc, sdlbin);
        if (sdlstate == null) {
            sdlstate = new SdlState();
            sdlstate.desc = desc;
            sdlstate.sdlvars = sdlbin;
            this.sdlstates.add(sdlstate);
        } else {
            sdlstate.sdlvars.update(sdlbin);
        }
        String statedescname = sdlbin.name.toString();
        if (statedescname.equals(this.sdlStatedesc)) {
            byte[] sdlbin_bs = sdlbin.compileAlone(Format.moul);
            Node.SDLNode sdlnode = new Node.SDLNode(RawNode.createEmpty());
            sdlnode.setType(27);
            sdlnode.setIdx(this.sdlIdx);
            sdlnode.setStatedescName(statedescname);
            sdlnode.setSdlBytecode(sdlbin_bs);
            this.manager.authserver.items.add(Comm.CommItem.SaveNode(sdlnode));
        }
    }

    private void HandlePlNetMsgPagingRoom(plNetMsgPagingRoom msg, ConnectionState cs) {
        m.msg("PlNetMsgPagingRoom");
        if (msg.parent.rooms.length != 1) {
            m.warn("Unhandled pagingroom");
        }
        int pagenum = msg.parent.rooms[0].location.pageid.getPageNumber();
        Page page = this.findPage(pagenum);
        if (page.loc == null) {
            page.loc = msg.parent.rooms[0].location;
        }
        if (page == null) {
            m.throwUncaughtException("unhandled");
        }
        if (msg.isPagingOut()) {
            this.removePlayerFromPage(page, cs.playerId, cs);
        } else if (!page.players.contains(cs.playerId)) {
            boolean isOwner;
            page.players.add(cs.playerId);
            if (page.ownersPlayerIdx == 0) {
                page.ownersPlayerIdx = cs.playerId;
                isOwner = true;
            } else {
                isOwner = false;
            }
            plNetMsgGroupOwner bmsg = plNetMsgGroupOwner.createWithInfo(page.loc, isOwner);
            GameMainServer.PropagateBuffer bmsg2 = GameMainServer.PropagateBuffer.createWithObj(Typeid.plNetMsgGroupOwner, bmsg);
            this.TestMsg(bmsg2);
            GameServer.SendMsg(cs, bmsg2);
        }
    }

    private void removePlayerFromPage(Page page, int playerIdx, ConnectionState cs) {
        boolean waspresent = page.players.remove((Object)playerIdx);
        if (!waspresent) {
            return;
        }
        if (page.ownersPlayerIdx == playerIdx) {
            if (page.players.size() != 0) {
                int newOwnerPlayerIdx = page.players.get(0);
                Manager.ensurePlayerIsOnline(newOwnerPlayerIdx);
                page.ownersPlayerIdx = newOwnerPlayerIdx;
                if (page.loc == null) {
                    m.throwUncaughtException("location was not set");
                }
                plNetMsgGroupOwner msg = plNetMsgGroupOwner.createWithInfo(page.loc, true);
                GameMainServer.PropagateBuffer msg2 = GameMainServer.PropagateBuffer.createWithObj(Typeid.plNetMsgGroupOwner, msg);
                this.TestMsg(msg2);
                GameServer.SendMsg(cs, msg2);
            } else {
                page.ownersPlayerIdx = 0;
            }
        }
    }

    private void HandlePlNetMsgGameMessage(plNetMsgGameMessage msg, ConnectionState cs) {
        m.msg("PlNetMsgGameMessage: " + msg.parent.obj.type.toString());
        if (msg.parent.obj.type == Typeid.plAvatarInputStateMsg) {
            plAvatarInputStateMsg msg2 = (plAvatarInputStateMsg)msg.parent.obj.prpobject.object;
            m.msg("  plAvatarInputStateMsg: " + Short.toString(msg2.state));
        }
    }

    private void HandlePlNetMsgGameStateRequest(plNetMsgGameStateRequest msg, ConnectionState cs) {
        m.msg("PlNetMsgGameStateRequest");
        int msgssent = 0;
        if (msg.parent.rooms.length == 0) {
            for (plLoadCloneMsg clone : this.clones) {
                plNetMsgLoadClone lc = plNetMsgLoadClone.createWithInfo(cs.playerId, clone, true);
                GameMainServer.PropagateBuffer outmsg = GameMainServer.PropagateBuffer.createWithObj(Typeid.plNetMsgLoadClone, lc);
                this.TestMsg(outmsg);
                GameServer.SendMsg(cs, outmsg);
                ++msgssent;
            }
        }
        for (SdlState sdlstate : this.sdlstates) {
            if (sdlstate.desc.hasCloneIds()) continue;
            boolean requested = false;
            for (plNetMsgRoomsList.Room room : msg.parent.rooms) {
                if (!sdlstate.desc.pageid.equals(room.location.pageid)) continue;
                requested = true;
                break;
            }
            if (!requested) continue;
            Uruobjectdesc desc = sdlstate.desc;
            SdlBinary sdlbin = sdlstate.sdlvars;
            plNetMsgSDLState ss = plNetMsgSDLState.createWithInfo(desc, sdlbin, true);
            GameMainServer.PropagateBuffer outmsg = GameMainServer.PropagateBuffer.createWithObj(Typeid.plNetMsgSDLState, ss);
            this.TestMsg(outmsg);
            GameServer.SendMsg(cs, outmsg);
            ++msgssent;
        }
        if (msg.parent.rooms.length == 0) {
            plNetMsgInitialAgeStateSent msg2 = plNetMsgInitialAgeStateSent.createWithNumsent(msgssent);
            GameMainServer.PropagateBuffer outmsg = GameMainServer.PropagateBuffer.createWithObj(Typeid.plNetMsgInitialAgeStateSent, msg2);
            this.TestMsg(outmsg);
            GameServer.SendMsg(cs, outmsg);
        }
    }

    private void HandlePlNetMsgRelevanceRegions(plNetMsgRelevanceRegions msg, ConnectionState cs) {
        m.msg("PlNetMsgRelevanceRegions");
    }

    private void HandlePlNetMsgMembersListReq(plNetMsgMembersListReq msg, ConnectionState cs) {
        m.msg("PlNetMsgMembersListReq");
        plNetMsgMembersList reply = plNetMsgMembersList.createWithPlayeridx(cs.playerId);
        for (ConnectionState member : this.connections) {
            if (member == cs) continue;
            Uruobjectdesc avatarDesc = this.connectionToClone.get((Object)cs).cloneKey.xdesc;
            plNetMsgMembersList.plNetMsgMemberInfoHelper info = plNetMsgMembersList.plNetMsgMemberInfoHelper.createWithAvatardesc(avatarDesc);
            info.clientGuid.setPlayerId(cs.playerId);
            info.clientGuid.setPlayerName(cs.player.getPlayerName());
            info.clientGuid.setAcctGuid(cs.player.getAccountGuid());
            reply.members.add(info);
        }
        GameMainServer.PropagateBuffer rep = GameMainServer.PropagateBuffer.createWithObj(Typeid.plNetMsgMembersList, reply);
        this.TestMsg(rep);
        GameServer.SendMsg(cs, rep);
    }

    private void HandlePlNetMsgPlayerPage(plNetMsgPlayerPage msg, ConnectionState cs) {
        m.msg("PlNetMsgPlayerPage");
    }

    private void HandlePlNetMsgTestAndSet(plNetMsgTestAndSet msg, ConnectionState cs) {
        if (msg.parent.lockRequest != 0) {
            plServerReplyMsg reply = plServerReplyMsg.createDefault();
            reply.parent.receivers.add(msg.parent.parent.parent.desc.toRef());
            reply.parent.broadcastFlags = 2048;
            reply.type = 1;
            PrpTaggedObject obj = PrpTaggedObject.createWithTypeidUruobj(Typeid.plServerReplyMsg, reply);
            plNetMsgGameMessage rep2 = plNetMsgGameMessage.createWithObjPlayeridx(obj, cs.playerId);
            PrpTaggedObject obj2 = PrpTaggedObject.createWithTypeidUruobj(Typeid.plNetMsgGameMessage, rep2);
            GameMainServer.PropagateBuffer rep = GameMainServer.PropagateBuffer.createWithObj(obj2);
            this.TestMsg(rep);
            GameServer.SendMsg(cs, rep);
        }
    }

    private void HandlePlNetMsgLoadClone(plNetMsgLoadClone loadclonemsg, ConnectionState cs) {
        plLoadCloneMsg lc2 = loadclonemsg.tryToGetLoadCloneMsg();
        if (lc2 == null) {
            m.throwUncaughtException("msg was not a plLoadCloneMsg");
        }
        plLoadCloneMsg cloneFromList = this.findClone(lc2);
        if (loadclonemsg.isLoading != 0) {
            if (cloneFromList != null) {
                m.msg("Updating clone.");
                this.clones.remove(cloneFromList);
                this.clones.add(lc2);
            } else {
                m.msg("Adding clone.");
                this.clones.add(lc2);
            }
            this.connectionToClone.put(cs, lc2);
        } else {
            m.msg("Removing clone.");
            boolean waspresent = this.clones.remove(cloneFromList);
            if (!waspresent) {
                m.warn("Tried to remove clone that is not present.");
            }
            this.removeSDLStates(loadclonemsg.desc.clonePlayerId, loadclonemsg.desc.cloneId);
        }
    }

    private void TestMsg(GameMainServer.GameMsg msg) {
        boolean enabled = true;
        byte[] data = null;
        try {
            Bytedeque c = new Bytedeque(Format.moul);
            c.writeShort(msg.type());
            msg.write(c);
            data = c.getAllBytes();
        }
        catch (Exception e2) {
            throw new nested(e2);
        }
        try {
            ByteArrayBytestream in = ByteArrayBytestream.createFromByteArray(data);
            GameMainServer.GameMsg readobj = GameMainServer.ReadMessage(in, false);
            if (((IBytestream)in).getBytesRemaining() != 0) {
                m.throwUncaughtException("didn't read all bytes");
            }
        }
        catch (Exception e3) {
            throw new nested(e3);
        }
        boolean dummy = false;
    }

    private void removeSDLStates(int clonePlayerId, int cloneId) {
        Iterator<SdlState> it = this.sdlstates.iterator();
        while (it.hasNext()) {
            SdlState sdlstate = it.next();
            if (!sdlstate.desc.hasCloneIds() || sdlstate.desc.clonePlayerId != clonePlayerId || cloneId != 0 && sdlstate.desc.cloneId != cloneId) continue;
            m.msg("Removing sdl state.");
            it.remove();
        }
    }

    public synchronized void setMinimumShutdownTime(int seconds) {
        int newTimeToQuit = DateTimeUtils.getCurrentTimeInSeconds() + seconds;
        if (this.timeToShutdown.get() < newTimeToQuit) {
            this.timeToShutdown.set(newTimeToQuit);
        }
    }

    public void expectPlayer(int playerIdx) {
    }

    static void SendMsg(ConnectionState cs, GameMainServer.GameMsg msg) {
        Bytedeque c = new Bytedeque(Format.moul);
        c.writeShort(msg.type());
        msg.write(c);
        byte[] data = c.getAllBytes();
        cs.sendMsgBytes(data);
    }

    private static class SdlState {
        Uruobjectdesc desc;
        SdlBinary sdlvars;

        private SdlState() {
        }
    }

    private static class Page {
        ageparser.PageInfo pageinfo;
        Location loc = null;
        ArrayList<Integer> players = new ArrayList();
        int ownersPlayerIdx;

        private Page() {
        }
    }
}

