/*
 * Decompiled with CFR 0.152.
 */
package moulserver;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import moulserver.AuthServer;
import moulserver.ConnectionState;
import moulserver.Node;
import moulserver.Server;
import prpobjects.Guid;
import shared.Concurrent;
import shared.m;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Comm {
    private final DustMap nodeChangeRegistrees = new DustMap();
    private final Map<Integer, Listener> playerIdxs = new ConcurrentHashMap<Integer, Listener>();
    private final Map<Integer, Set<Listener>> nodeChangeListeners = new ConcurrentHashMap<Integer, Set<Listener>>();
    private final Map<Integer, Set<Listener>> nodeLinkListeners = new ConcurrentHashMap<Integer, Set<Listener>>();
    ConcurrentHashMap<CommItem, CommTrigger> callers = Concurrent.getConcurrentHashMap();

    public void registerForNodeChange(int nodeIdx, Queue<CommItem> queue) {
        this.nodeChangeRegistrees.addQueue(nodeIdx, queue);
    }

    public void triggerNodeChange(int nodeIdx, CommItem msg) {
        this.nodeChangeRegistrees.triggerIdx(nodeIdx, msg);
    }

    public Iterable<Listener> getNodeChangeListeners(Integer nodeIdx) {
        return this.nodeChangeListeners.get(nodeIdx);
    }

    public Iterable<Listener> getNodeLinkListeners(Integer nodeIdx) {
        return this.nodeLinkListeners.get(nodeIdx);
    }

    public Listener getPlayerIdxListener(Integer playerIdx) {
        return this.playerIdxs.get(playerIdx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<Listener> getNodeListeners(Map<Integer, Set<Listener>> listenersMap, Integer nodeIdx) {
        Map<Integer, Set<Listener>> map = listenersMap;
        synchronized (map) {
            Set<Listener> listeners = listenersMap.get(nodeIdx);
            if (listeners == null) {
                listeners = Concurrent.getConcurrentSet();
                listenersMap.put(nodeIdx, listeners);
            }
            return listeners;
        }
    }

    public Listener MakeListener() {
        Listener listener = new Listener(this);
        return listener;
    }

    public <T extends CommItem> T SendAndWait(CommItem msg, Queue<CommItem> receiver) {
        CommItem r = this.SendAndWait2(msg, receiver);
        return (T)r;
    }

    public CommItem SendAndWait2(CommItem msg, Queue<CommItem> receiver) {
        CommTrigger trigger = new CommTrigger();
        this.callers.put(msg, trigger);
        receiver.add(msg);
        CommItem result = trigger.await();
        return result;
    }

    public void Respond(CommItem caller, CommItem response) {
        CommTrigger trigger = this.callers.remove(caller);
        trigger.trigger(response);
    }

    public static class CommTrigger {
        private CountDownLatch latch = new CountDownLatch(1);
        private CommItem response;

        public void trigger(CommItem response) {
            this.response = response;
            this.latch.countDown();
        }

        public CommItem await() {
            while (true) {
                try {
                    this.latch.await();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
            return this.response;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CommItemType {
        SendMessage,
        HandleMessage,
        Terminate,
        NodeChange,
        GetAgeSdl,
        ResponseNode,
        SaveNode;

    }

    public static class CommItem {
        CommItemType type;
        Server.ServerMsg msg;
        ConnectionState connstate;
        Integer nodeIdx;
        byte[] data;
        Guid guid;
        Node node;

        private CommItem() {
        }

        public static CommItem SendMessage(Server.ServerMsg msg) {
            CommItem r = new CommItem();
            r.type = CommItemType.SendMessage;
            r.msg = msg;
            return r;
        }

        public static CommItem HandleMessage(Server.ServerMsg msg, ConnectionState connstate) {
            CommItem r = new CommItem();
            r.type = CommItemType.HandleMessage;
            r.msg = msg;
            r.connstate = connstate;
            return r;
        }

        public static CommItem NodeChange(AuthServer.VaultNodeChanged msg, ConnectionState sender) {
            CommItem r = new CommItem();
            r.type = CommItemType.NodeChange;
            r.msg = msg;
            r.connstate = sender;
            return r;
        }

        public static CommItem Terminate() {
            CommItem r = new CommItem();
            r.type = CommItemType.Terminate;
            return r;
        }

        public static CommItem GetAgeSdl(Guid ageInstanceGuid) {
            CommItem r = new CommItem();
            r.type = CommItemType.GetAgeSdl;
            r.guid = ageInstanceGuid;
            return r;
        }

        public static CommItem ResponseNode(Node node) {
            CommItem r = new CommItem();
            r.type = CommItemType.ResponseNode;
            r.node = node;
            return r;
        }

        public static CommItem SaveNode(Node node) {
            CommItem r = new CommItem();
            r.type = CommItemType.SaveNode;
            r.node = node;
            return r;
        }

        public CommItemType getType() {
            return this.type;
        }
    }

    public static class Listener {
        private Queue<CommItem> mainQueue = new ConcurrentLinkedQueue<CommItem>();
        private Comm comm;

        public Listener(Comm comm) {
            this.comm = comm;
        }

        public void registerForNodeChange(int nodeIdx) {
            Comm.getNodeListeners(this.comm.nodeChangeListeners, nodeIdx).add(this);
        }

        public void registerForNodeLink(int nodeIdx) {
            Comm.getNodeListeners(this.comm.nodeLinkListeners, nodeIdx).add(this);
        }

        public void registerForPlayerIdx(int playerIdx) {
            this.comm.playerIdxs.put(playerIdx, this);
        }

        public boolean hasItem() {
            return this.mainQueue.peek() != null;
        }

        public CommItem getNextItem() {
            return this.mainQueue.poll();
        }

        public void addItem(CommItem item) {
            this.mainQueue.add(item);
        }

        public void unregister() {
            m.err("unimplemented");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DustMap
    extends ConcurrentHashMap<Integer, Set<WeakReference<Queue<CommItem>>>> {
        public void addQueue(int idx, Queue<CommItem> queue) {
            WeakReference<Queue<CommItem>> ref = new WeakReference<Queue<CommItem>>(queue);
            Set<WeakReference<Queue<CommItem>>> curset = this.getOrCreateSet(idx);
            curset.add(ref);
        }

        public Set<Queue<CommItem>> getCurrentSet(int idx) {
            Set curset = (Set)this.get(idx);
            if (curset == null) {
                return Collections.emptySet();
            }
            HashSet<Queue<CommItem>> r = new HashSet<Queue<CommItem>>();
            for (WeakReference ref : curset) {
                Queue listener = (Queue)ref.get();
                if (listener == null) continue;
                r.add(listener);
            }
            return r;
        }

        private synchronized Set<WeakReference<Queue<CommItem>>> getOrCreateSet(int idx) {
            Set<WeakReference<Queue<CommItem>>> curset = (Set<WeakReference<Queue<CommItem>>>)this.get(idx);
            if (curset == null) {
                curset = Concurrent.getConcurrentSet();
                this.put(idx, curset);
            }
            return curset;
        }

        public void triggerIdx(int idx, CommItem msg) {
            Set<Queue<CommItem>> curset = this.getCurrentSet(idx);
            for (Queue<CommItem> listener : curset) {
                listener.add(msg);
            }
        }
    }
}

